/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core.optimizer;

import com.google.inject.Inject;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opt4j.core.Archive;
import org.opt4j.core.IndividualBuilder;
import org.opt4j.core.Population;
import org.opt4j.core.optimizer.Completer;
import org.opt4j.core.optimizer.Control;
import org.opt4j.core.optimizer.Optimizer;
import org.opt4j.core.optimizer.OptimizerIterationListener;
import org.opt4j.core.optimizer.OptimizerStateListener;
import org.opt4j.core.optimizer.StopException;
import org.opt4j.core.optimizer.TerminationException;

public abstract class AbstractOptimizer
implements Optimizer {
    protected int iteration = 0;
    protected final Population population;
    protected final Archive archive;
    protected final IndividualBuilder individualBuilder;
    protected final Completer completer;
    protected final Control control;
    protected final Set<OptimizerStateListener> stateListeners = new CopyOnWriteArraySet<OptimizerStateListener>();
    protected final Set<OptimizerIterationListener> iterationListeners = new CopyOnWriteArraySet<OptimizerIterationListener>();
    protected boolean optimizing = false;

    public AbstractOptimizer(Population population, Archive archive, IndividualBuilder individualBuilder, Completer completer, Control control) {
        this.population = population;
        this.archive = archive;
        this.individualBuilder = individualBuilder;
        this.completer = completer;
        this.control = control;
    }

    @Inject
    protected void injectListeners(Set<OptimizerStateListener> stateListeners, Set<OptimizerIterationListener> iterationListeners) {
        this.stateListeners.addAll(stateListeners);
        this.iterationListeners.addAll(iterationListeners);
    }

    @Override
    public int getIteration() {
        return this.iteration;
    }

    @Override
    public boolean isRunning() {
        return this.optimizing;
    }

    protected void nextIteration() throws TerminationException, StopException {
        this.completer.complete(this.population);
        this.archive.update(this.population);
        for (OptimizerIterationListener listener : this.iterationListeners) {
            listener.iterationComplete(this, this.iteration);
        }
        ++this.iteration;
        this.control.checkpointStop();
    }

    @Override
    public void startOptimization() {
        this.optimizing = true;
        for (OptimizerStateListener listener : this.stateListeners) {
            listener.optimizationStarted(this);
        }
    }

    @Override
    public void stopOptimization() {
        this.optimizing = false;
        for (OptimizerStateListener listener : this.stateListeners) {
            listener.optimizationStopped(this);
        }
    }

    @Override
    public void addOptimizerIterationListener(OptimizerIterationListener listener) {
        this.iterationListeners.add(listener);
    }

    @Override
    public void addOptimizerStateListener(OptimizerStateListener listener) {
        this.stateListeners.add(listener);
    }

    @Override
    public void removeOptimizerIterationListener(OptimizerIterationListener listener) {
        this.iterationListeners.remove(listener);
    }

    @Override
    public void removeOptimizerStateListener(OptimizerStateListener listener) {
        this.stateListeners.remove(listener);
    }
}

