/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core.domination;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opt4j.core.Constraint;
import org.opt4j.core.Constraints;
import org.opt4j.core.Objective;
import org.opt4j.core.Objectives;
import org.opt4j.core.SatisfactionConstraint;
import org.opt4j.core.domination.DominationStrategy;
import org.opt4j.core.domination.ParetoDomination;

@Singleton
public class GoalAttainmentDomination
implements DominationStrategy {
    protected ParetoDomination paretoDomination;

    @Inject
    public GoalAttainmentDomination(ParetoDomination paretoDomination) {
        this.paretoDomination = paretoDomination;
    }

    @Override
    public boolean dominates(Objectives o1, Objectives o2) {
        List<Constraint> eligibleConstraints = this.getAllElibleConstraints(o1);
        if (eligibleConstraints.size() == 0) {
            return this.paretoDomination.dominates(o1, o2);
        }
        Constraints constraints1 = o1.getConstraints();
        Constraints constraints2 = o2.getConstraints();
        ArrayList<Double> notFullfilledConstraints1 = new ArrayList<Double>();
        ArrayList<Double> notFullfilledConstraints2 = new ArrayList<Double>();
        double[] allConstraintValues1 = new double[eligibleConstraints.size()];
        double[] allConstraintValues2 = new double[eligibleConstraints.size()];
        boolean valuesOfViolatedConstraintsAreEqual = true;
        boolean constraint2hasViolationsConstraint1doesNotHave = false;
        int i = 0;
        for (Constraint c : eligibleConstraints) {
            if (this.getObjective(c).getSign() == Objective.Sign.MIN) {
                allConstraintValues1[i] = constraints1.get(c).getDouble();
                allConstraintValues2[i] = constraints2.get(c).getDouble();
            } else {
                allConstraintValues1[i] = -constraints1.get(c).getDouble().doubleValue();
                allConstraintValues2[i] = -constraints2.get(c).getDouble().doubleValue();
            }
            ++i;
            boolean violation = false;
            switch (c.getDirection()) {
                case less: {
                    if (!(constraints1.get(c).getDouble() < c.getLimit())) {
                        violation = true;
                        break;
                    }
                    if (constraints2.get(c).getDouble() < c.getLimit()) break;
                    constraint2hasViolationsConstraint1doesNotHave = true;
                    break;
                }
                case greater: {
                    if (!(constraints1.get(c).getDouble() > c.getLimit())) {
                        violation = true;
                        break;
                    }
                    if (constraints2.get(c).getDouble() > c.getLimit()) break;
                    constraint2hasViolationsConstraint1doesNotHave = true;
                    break;
                }
                case lessOrEqual: {
                    if (!(constraints1.get(c).getDouble() <= c.getLimit())) {
                        violation = true;
                        break;
                    }
                    if (constraints2.get(c).getDouble() <= c.getLimit()) break;
                    constraint2hasViolationsConstraint1doesNotHave = true;
                    break;
                }
                case greaterOrEqual: {
                    if (!(constraints1.get(c).getDouble() >= c.getLimit())) {
                        violation = true;
                        break;
                    }
                    if (constraints2.get(c).getDouble() >= c.getLimit()) break;
                    constraint2hasViolationsConstraint1doesNotHave = true;
                    break;
                }
                case equal: {
                    if (constraints1.get(c).getDouble().doubleValue() != c.getLimit()) {
                        violation = true;
                        break;
                    }
                    if (constraints2.get(c).getDouble().doubleValue() == c.getLimit()) break;
                    constraint2hasViolationsConstraint1doesNotHave = true;
                    break;
                }
                default: {
                    throw new RuntimeException("No matching case in switch statement!");
                }
            }
            if (!violation) continue;
            double d1 = constraints1.get(c).getDouble();
            double d2 = constraints2.get(c).getDouble();
            if (this.getObjective(c).getSign() == Objective.Sign.MAX) {
                d1 = -d1;
                d2 = -d2;
            }
            notFullfilledConstraints1.add(d1);
            notFullfilledConstraints2.add(d2);
            if (d1 == d2) continue;
            valuesOfViolatedConstraintsAreEqual = false;
        }
        if (notFullfilledConstraints1.size() > 0 && !valuesOfViolatedConstraintsAreEqual) {
            return this.paretoDomination.dominates(this.listToArray(notFullfilledConstraints1), this.listToArray(notFullfilledConstraints2));
        }
        if (constraint2hasViolationsConstraint1doesNotHave) {
            return true;
        }
        return this.paretoDomination.dominates(allConstraintValues1, allConstraintValues2);
    }

    protected double[] listToArray(List<Double> list) {
        double[] array = new double[list.size()];
        int i = 0;
        Iterator<Double> iterator = list.iterator();
        while (iterator.hasNext()) {
            double d;
            array[i] = d = iterator.next().doubleValue();
            ++i;
        }
        return array;
    }

    protected List<Constraint> getAllElibleConstraints(Objectives o) {
        Constraints constraints = o.getConstraints();
        ArrayList<Constraint> returnList = new ArrayList<Constraint>();
        Iterator iterator = constraints.iterator();
        while (iterator.hasNext()) {
            Constraint c = (Constraint)iterator.next().getKey();
            if (!this.isEligibleConstraint(c)) continue;
            returnList.add(c);
        }
        return returnList;
    }

    protected boolean isEligibleConstraint(Constraint constraint) {
        return constraint instanceof SatisfactionConstraint;
    }

    protected Objective getObjective(Constraint constraint) {
        if (constraint instanceof SatisfactionConstraint) {
            return ((SatisfactionConstraint)constraint).getObjective();
        }
        throw new RuntimeException("Wrong constraint type! Can't get objective!");
    }

    @Override
    public boolean weaklyDominates(Objectives o1, Objectives o2) {
        double[] a1 = o1.array();
        double[] a2 = o2.array();
        boolean equals = true;
        int i = 0;
        while (i < a1.length) {
            if (a1[i] != a2[i]) {
                equals = false;
                break;
            }
            ++i;
        }
        return equals || this.dominates(o1, o2);
    }
}

