/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core;

import com.google.inject.Inject;
import java.util.Map;
import org.opt4j.core.Constraints;
import org.opt4j.core.CriterionSet;
import org.opt4j.core.Objective;
import org.opt4j.core.Value;
import org.opt4j.core.domination.DominationStrategy;
import org.opt4j.core.domination.ParetoDomination;

public class Objectives
extends CriterionSet<Objective> {
    protected boolean feasible = true;
    protected Constraints constraints = new Constraints();
    protected DominationStrategy dominationStrategy;

    @Deprecated
    public Objectives() {
        this.dominationStrategy = new ParetoDomination();
    }

    @Inject
    public Objectives(DominationStrategy strategy) {
        this.dominationStrategy = strategy;
    }

    public Constraints getConstraints() {
        return this.constraints;
    }

    public void setConstraints(Constraints constraints) {
        this.constraints = constraints;
    }

    public DominationStrategy getDominationStrategy() {
        return this.dominationStrategy;
    }

    public boolean isFeasible() {
        return this.feasible;
    }

    public void setFeasible(boolean feasible) {
        this.feasible = feasible;
    }

    @Override
    public double[] array() {
        if (this.array == null) {
            this.submit();
        }
        return this.array;
    }

    protected synchronized void submit() {
        if (this.array == null) {
            this.array = new double[this.size()];
            int i = 0;
            for (Map.Entry entry : this) {
                Objective objective = (Objective)entry.getKey();
                Value<?> value = entry.getValue();
                Double v = value.getDouble();
                this.array[i] = v == null ? Double.MAX_VALUE : (objective.getSign() == Objective.Sign.MAX ? -v.doubleValue() : v);
                ++i;
            }
        }
    }

    public boolean weaklyDominates(Objectives opponent) {
        return this.dominationStrategy.weaklyDominates(this, opponent);
    }

    public boolean dominates(Objectives opponent) {
        return this.dominationStrategy.dominates(this, opponent);
    }

    public String toString() {
        String s = "";
        for (Map.Entry entry : this.map.entrySet()) {
            Objective o = (Objective)entry.getKey();
            Value v = (Value)entry.getValue();
            s = String.valueOf(s) + o + "=" + v + " ";
        }
        return s;
    }
}

