/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualCollectionListener;

public class IndividualCollection
implements Set<Individual> {
    protected final List<Individual> individuals = new ArrayList<Individual>();
    protected final Set<IndividualCollectionListener> listeners = new CopyOnWriteArraySet<IndividualCollectionListener>();

    @Override
    public boolean add(Individual individual) {
        boolean b = false;
        if (!this.individuals.contains(individual)) {
            b = this.individuals.add(individual);
        }
        if (b) {
            for (IndividualCollectionListener listener : this.listeners) {
                listener.individualAdded(this, individual);
            }
        }
        return b;
    }

    @Override
    public Iterator<Individual> iterator() {
        return new ListIterator();
    }

    @Override
    public int size() {
        return this.individuals.size();
    }

    public void addListener(IndividualCollectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IndividualCollectionListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void clear() {
        ArrayList<Individual> list = new ArrayList<Individual>(this);
        this.removeAll(list);
    }

    @Override
    public boolean addAll(Collection<? extends Individual> c) {
        boolean b = false;
        for (Individual individual : c) {
            b |= this.add(individual);
        }
        return b;
    }

    @Override
    public boolean contains(Object o) {
        return this.individuals.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.individuals.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.individuals.isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        boolean value = this.individuals.remove(o);
        if (value) {
            for (IndividualCollectionListener listener : this.listeners) {
                listener.individualRemoved(this, (Individual)o);
            }
        }
        return value;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean b = false;
        for (Object obj : c) {
            b |= this.remove(obj);
        }
        return b;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        HashSet<Individual> remove = new HashSet<Individual>();
        for (Individual individual : this.individuals) {
            if (c.contains(individual)) continue;
            remove.add(individual);
        }
        return this.removeAll(remove);
    }

    @Override
    public Object[] toArray() {
        return this.individuals.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.individuals.toArray(a);
    }

    class ListIterator
    implements Iterator<Individual> {
        private int i = 0;

        ListIterator() {
        }

        @Override
        public boolean hasNext() {
            return IndividualCollection.this.individuals.size() > this.i;
        }

        @Override
        public Individual next() {
            return IndividualCollection.this.individuals.get(this.i++);
        }

        @Override
        public void remove() {
            --this.i;
            IndividualCollection.this.remove(IndividualCollection.this.individuals.get(this.i));
        }
    }
}

