/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualBuilder;
import org.opt4j.core.IndividualStateListener;
import org.opt4j.core.problem.Creator;
import org.opt4j.core.problem.Genotype;

public class AbstractIndividualBuilder<I extends Individual>
implements IndividualBuilder {
    protected final Creator<Genotype> creator;
    protected final Provider<I> individualProvider;
    protected Set<IndividualStateListener> individualStateListeners = new CopyOnWriteArraySet<IndividualStateListener>();

    public AbstractIndividualBuilder(Provider<I> individualProvider, Creator creator) {
        this.individualProvider = individualProvider;
        this.creator = creator;
    }

    @Inject
    protected void injectListeners(Set<IndividualStateListener> listeners) {
        this.individualStateListeners.addAll(listeners);
    }

    @Override
    public void addIndividualStateListener(IndividualStateListener listener) {
        this.individualStateListeners.add(listener);
    }

    @Override
    public Individual build() {
        Individual individual = (Individual)this.individualProvider.get();
        individual.setIndividualStatusListeners(this.individualStateListeners);
        Genotype genotype = this.creator.create();
        individual.setGenotype(genotype);
        return individual;
    }

    @Override
    public Individual build(Genotype genotype) {
        Individual individual = (Individual)this.individualProvider.get();
        individual.setIndividualStatusListeners(this.individualStateListeners);
        individual.setGenotype(genotype);
        return individual;
    }

    @Override
    public void removeIndividualStateListener(IndividualStateListener listener) {
        this.individualStateListeners.remove(listener);
    }
}

