/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.config.visualization;

import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Singleton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JToolBar;
import org.opt4j.config.ExecutionEnvironment;
import org.opt4j.config.Icons;
import org.opt4j.config.visualization.FileOperations;
import org.opt4j.config.visualization.SelectedModules;
import org.opt4j.config.visualization.Startupable;

@Singleton
public class ToolBar
extends JToolBar
implements FileOperations.FileOperationsListener,
Startupable {
    protected JButton execute;
    protected JButton save;
    protected JButton saveAs;
    protected JButton load;
    protected final ExecutionEnvironment executionEnvironment;
    protected final FileOperations fileOperations;
    protected final SelectedModules selectedModules;

    @Inject
    public ToolBar(ExecutionEnvironment executionEnvironment, SelectedModules selectedModules, FileOperations fileOperations) {
        this.executionEnvironment = executionEnvironment;
        this.selectedModules = selectedModules;
        this.fileOperations = fileOperations;
    }

    @Inject
    public void init() {
        this.fileOperations.addListener(this);
        this.setFloatable(false);
    }

    @Override
    public void startup() {
        this.execute = new JButton("Run ", Icons.getIcon("icons/play.png")){
            {
                this.setFocusable(false);
                this.setMnemonic(82);
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        HashSet<Module> modules = new HashSet<Module>();
                        modules.addAll((this).ToolBar.this.selectedModules);
                        (this).ToolBar.this.executionEnvironment.execute(modules);
                    }
                });
            }
        };
        this.load = new JButton("Load ... ", Icons.getIcon("icons/folder.png")){
            {
                this.setFocusable(false);
                this.setMnemonic(76);
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        (this).ToolBar.this.fileOperations.load();
                    }
                });
            }
        };
        this.save = new JButton("Save ", Icons.getIcon("icons/disk.png")){
            {
                this.setFocusable(false);
                this.setMnemonic(83);
                this.setEnabled(false);
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        (this).ToolBar.this.fileOperations.save();
                    }
                });
            }
        };
        this.saveAs = new JButton("Save As ... ", Icons.getIcon("icons/disk.png")){
            {
                this.setFocusable(false);
                this.setMnemonic(65);
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        (this).ToolBar.this.fileOperations.saveAs();
                    }
                });
            }
        };
        this.add(this.execute);
        this.addSeparator();
        this.add(this.load);
        this.add(this.save);
        this.add(this.saveAs);
        this.addSeparator();
    }

    @Override
    public void setCurrentFile(File file) {
        this.save.setEnabled(file != null);
    }
}

