/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.config.visualization;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.opt4j.config.Icons;
import org.opt4j.config.visualization.About;
import org.opt4j.config.visualization.ApplicationFrame;
import org.opt4j.config.visualization.FileOperations;
import org.opt4j.config.visualization.Startupable;

public class Menu
extends JMenuBar
implements FileOperations.FileOperationsListener,
Startupable {
    JMenuItem load = new JMenuItem("Load ...", Icons.getIcon("icons/folder.png"));
    JMenuItem save = new JMenuItem("Save", Icons.getIcon("icons/disk.png"));
    JMenuItem saveAs = new JMenuItem("Save As ...", Icons.getIcon("icons/disk.png"));
    JMenuItem about = new JMenuItem("About");
    protected final FileOperations fileOperations;
    protected final Provider<ApplicationFrame> frame;
    protected final About aboutInfo;
    protected File file = null;

    @Inject
    public Menu(FileOperations fileOperations, About about, Provider<ApplicationFrame> frame) {
        this.fileOperations = fileOperations;
        this.aboutInfo = about;
        this.frame = frame;
    }

    @Override
    public void startup() {
        JMenu file = new JMenu("File");
        JMenu etc = new JMenu("?");
        file.setMnemonic(70);
        this.add(file);
        this.add(etc);
        this.load.setMnemonic(76);
        this.load.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Menu.this.fileOperations.load();
            }
        });
        this.save.setMnemonic(83);
        this.save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Menu.this.fileOperations.save();
            }
        });
        this.save.setEnabled(false);
        this.saveAs.setMnemonic(65);
        this.saveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Menu.this.fileOperations.saveAs();
            }
        });
        this.about.setMnemonic(65);
        this.about.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDialog dialog = Menu.this.aboutInfo.getDialog((ApplicationFrame)Menu.this.frame.get());
                dialog.pack();
                dialog.setVisible(true);
            }
        });
        file.add(this.load);
        file.add(this.save);
        file.add(this.saveAs);
        etc.add(this.about);
    }

    @Inject
    public void init() {
        this.fileOperations.addListener(this);
    }

    @Override
    public void setCurrentFile(File file) {
        if (file != null) {
            this.save.setEnabled(true);
        } else {
            this.save.setEnabled(false);
        }
    }
}

