/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.config.visualization;

import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Singleton;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.JFileChooser;
import org.opt4j.config.ModuleLoader;
import org.opt4j.config.ModuleRegister;
import org.opt4j.config.ModuleSaver;
import org.opt4j.config.PropertyModule;
import org.opt4j.config.visualization.FileChooser;
import org.opt4j.config.visualization.SelectedModules;

@Singleton
public class FileOperations {
    protected File file = null;
    protected final FileChooser fileChooser;
    protected final ModuleRegister moduleRegister;
    protected final SelectedModules selectedModules;
    protected final Set<FileOperationsListener> listeners = new CopyOnWriteArraySet<FileOperationsListener>();

    @Inject
    public FileOperations(ModuleRegister moduleRegister, SelectedModules selectedModules, FileChooser fileChooser) {
        this.moduleRegister = moduleRegister;
        this.selectedModules = selectedModules;
        this.fileChooser = fileChooser;
    }

    protected void setFile(File file) {
        this.file = file;
        for (FileOperationsListener listener : this.listeners) {
            listener.setCurrentFile(file);
        }
    }

    public File getFile() {
        return this.file;
    }

    public void load() {
        JFileChooser fc = this.fileChooser.get();
        fc.setFileFilter(null);
        fc.setVisible(true);
        fc.setCurrentDirectory(this.getFile());
        int returnVal = fc.showDialog(null, "Load");
        if (returnVal == 0) {
            this.load(fc.getSelectedFile());
        }
    }

    public void saveAs() {
        JFileChooser fc = this.fileChooser.get();
        fc.setFileFilter(null);
        fc.setVisible(true);
        fc.setCurrentDirectory(this.getFile());
        int returnVal = fc.showDialog(null, "Save");
        if (returnVal == 0) {
            this.save(fc.getSelectedFile());
        }
    }

    public void load(File file) {
        this.setFile(file);
        this.selectedModules.clear();
        ModuleLoader loader = new ModuleLoader(this.moduleRegister);
        Collection<? extends Module> modules = loader.load(file);
        for (Module module : modules) {
            PropertyModule m = new PropertyModule(module);
            this.selectedModules.add(m);
        }
        System.out.println("Loaded configuration from " + file);
    }

    public void save() {
        this.save(this.file);
    }

    public void save(File file) {
        this.setFile(file);
        ModuleSaver saver = new ModuleSaver();
        SelectedModules modules = this.selectedModules;
        saver.save(file, (Collection<? extends Module>)modules);
        System.out.println("Saved configuration to " + file);
    }

    public synchronized void addListener(FileOperationsListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeListener(FileOperationsListener listener) {
        this.listeners.remove(listener);
    }

    public static interface FileOperationsListener {
        public void setCurrentFile(File var1);
    }
}

