/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.config.visualization;

import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.opt4j.config.ExecutionEnvironment;
import org.opt4j.config.Task;
import org.opt4j.config.TaskListener;
import org.opt4j.config.visualization.Format;
import org.opt4j.config.visualization.TasksPanel;
import org.opt4j.viewer.DelayTask;

public class DefaultTasksPanel
extends TasksPanel
implements TaskListener {
    protected final ExecutionEnvironment executionEnvironment;
    protected final Format format;
    protected JTable table;
    protected JScrollPane scroll;
    protected DelayTask delay = new DelayTask(40L);

    @Inject
    public DefaultTasksPanel(ExecutionEnvironment executionEnvironment, Format format) {
        this.executionEnvironment = executionEnvironment;
        this.format = format;
    }

    @Inject
    public void init() {
        this.executionEnvironment.addListener(this);
    }

    @Override
    public void startup() {
        this.setLayout(new BorderLayout());
        AbstractTableModel model = this.getModel();
        this.table = this.getTable();
        this.table.setModel(model);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(500);
        this.scroll = new JScrollPane(this.table, 20, 31);
        this.add((Component)this.scroll, "Center");
    }

    protected JTable getTable() {
        return new Table();
    }

    protected AbstractTableModel getModel() {
        return new Model();
    }

    @Override
    public void added(Task task) {
        this.table.revalidate();
        this.table.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultTasksPanel.this.scroll.getVerticalScrollBar().setValue(DefaultTasksPanel.this.table.getRowCount() * 120);
            }
        });
    }

    @Override
    public void stateChanged(Task task) {
        this.delay.execute(new Runnable(){

            @Override
            public void run() {
                DefaultTasksPanel.this.table.revalidate();
                DefaultTasksPanel.this.table.repaint();
            }
        });
    }

    protected class Model
    extends AbstractTableModel {
        protected String[] columnNames = new String[]{"Task", "State"};

        protected Model() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return DefaultTasksPanel.this.executionEnvironment.getTasks().size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            Task task = DefaultTasksPanel.this.executionEnvironment.getTasks().get(row);
            if (column == 0) {
                return String.valueOf(row) + " " + task.toString();
            }
            if (column == 1) {
                if (task.getException() != null) {
                    return "EXCEPTION: \n" + task.getException();
                }
                return task.getState();
            }
            return null;
        }

        @Override
        public String getColumnName(int i) {
            return this.columnNames[i];
        }
    }

    protected class Table
    extends JTable {
        protected Table() {
        }

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            Component c = super.prepareRenderer(renderer, row, column);
            Task task = DefaultTasksPanel.this.executionEnvironment.getTasks().get(row);
            if (task.getException() == null) {
                c.setForeground(Color.BLACK);
            } else {
                c.setForeground(Color.RED);
            }
            if (c instanceof JComponent) {
                JComponent jc = (JComponent)c;
                jc.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
                char[] chars = this.getValueAt(row, column).toString().toCharArray();
                int length = jc.getFontMetrics(jc.getFont()).charsWidth(chars, 0, chars.length);
                if (this.getColumnModel().getColumn(column).getWidth() < length) {
                    jc.setToolTipText(DefaultTasksPanel.this.format.formatTooltip(this.getValueAt(row, column).toString()));
                } else {
                    jc.setToolTipText(null);
                }
            }
            return c;
        }
    }
}

