/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.config.visualization;

import com.google.inject.Inject;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.opt4j.config.PropertyModule;
import org.opt4j.config.annotations.Panel;
import org.opt4j.config.visualization.FileChooser;
import org.opt4j.config.visualization.Format;
import org.opt4j.config.visualization.ModuleTransferable;
import org.opt4j.config.visualization.PropertyPanel;
import org.opt4j.config.visualization.SelectedModules;
import org.opt4j.config.visualization.SelectedPanel;
import org.opt4j.config.visualization.SetListener;

public class DefaultSelectedPanel
extends SelectedPanel
implements SetListener {
    protected final TabbedPane tabs = new TabbedPane();
    protected final Format format;
    protected final SelectedModules selectedModules;
    protected final FileChooser fileChooser;
    protected final Map<PropertyModule, PropertyPanel> map = new HashMap<PropertyModule, PropertyPanel>();
    protected final DropTarget dropTarget;
    protected final DropTargetListener dropListener = new DropTargetAdapter(){

        @Override
        public void drop(DropTargetDropEvent dtde) {
            Transferable transferable = dtde.getTransferable();
            DataFlavor flaver = ModuleTransferable.localModuleFlaver;
            try {
                if (transferable.isDataFlavorSupported(flaver)) {
                    Object o = transferable.getTransferData(flaver);
                    PropertyModule module = (PropertyModule)o;
                    DefaultSelectedPanel.this.selectedModules.add(module);
                    dtde.acceptDrop(2);
                    dtde.getDropTargetContext().dropComplete(true);
                } else {
                    dtde.rejectDrop();
                }
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    };

    @Inject
    public DefaultSelectedPanel(Format format, SelectedModules selectedModules, FileChooser fileChooser) {
        this.format = format;
        this.selectedModules = selectedModules;
        this.fileChooser = fileChooser;
        this.dropTarget = new DropTarget(this, this.dropListener);
    }

    @Inject
    public void init() {
        this.selectedModules.addListener(this);
    }

    @Override
    public void startup() {
        this.setLayout(new BorderLayout());
        this.add(this.tabs);
    }

    protected void addModule(PropertyModule module) {
        if (!this.map.keySet().contains(module)) {
            PropertyPanel panel = null;
            Panel p = module.getModule().getClass().getAnnotation(Panel.class);
            if (p != null) {
                Class<? extends PropertyPanel> clazz = p.value();
                try {
                    Constructor<? extends PropertyPanel> cstr = clazz.getConstructor(PropertyModule.class, FileChooser.class, Format.class);
                    panel = cstr.newInstance(module, this.fileChooser, this.format);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                panel = new PropertyPanel(module, this.fileChooser, this.format);
            }
            MyScrollPane scroll = new MyScrollPane(panel);
            scroll.setVerticalScrollBarPolicy(20);
            scroll.setPreferredSize(new Dimension(300, 300));
            String name = this.format.getName(module);
            String tooltip = this.format.getTooltip(module);
            int count = this.selectedModules.subSet((PropertyModule)this.selectedModules.first(), module).size();
            this.tabs.insertTab(name, null, scroll, tooltip, count);
            this.tabs.setSelectedIndex(count);
            this.tabs.setTabComponentAt(count, new TabComponent(module));
            this.map.put(module, panel);
        } else {
            int index = this.tabs.getIndex(module);
            if (index != -1) {
                this.tabs.setSelectedIndex(index);
            }
        }
    }

    protected void removeModule(PropertyModule module) {
        int index = this.tabs.getIndex(module);
        if (index != -1) {
            this.map.remove(module);
            this.tabs.remove(index);
        }
    }

    @Override
    public void moduleAdded(Collection<PropertyModule> collection, PropertyModule module) {
        this.addModule(module);
    }

    @Override
    public void moduleRemoved(Collection<PropertyModule> collection, PropertyModule module) {
        this.removeModule(module);
    }

    protected class MyScrollPane
    extends JScrollPane {
        PropertyPanel panel;

        public MyScrollPane(PropertyPanel panel) {
            super(panel);
            this.panel = panel;
        }

        public PropertyPanel getPanel() {
            return this.panel;
        }
    }

    protected class TabComponent
    extends JPanel {
        private final PropertyModule module;
        private final MouseListener buttonMouseListener;

        public TabComponent(PropertyModule module) {
            super(new FlowLayout(0, 0, 0));
            this.buttonMouseListener = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    Component component = e.getComponent();
                    if (component instanceof AbstractButton) {
                        AbstractButton button = (AbstractButton)component;
                        button.setBorderPainted(true);
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    Component component = e.getComponent();
                    if (component instanceof AbstractButton) {
                        AbstractButton button = (AbstractButton)component;
                        button.setBorderPainted(false);
                    }
                }
            };
            this.module = module;
            this.setOpaque(false);
            String name = DefaultSelectedPanel.this.format.getName(module);
            ImageIcon icon = DefaultSelectedPanel.this.format.getIcon(module);
            if (name.length() > 22) {
                name = String.valueOf(name.substring(0, 18)) + "...";
            }
            JLabel label = new JLabel(name, icon, 2);
            this.add(label);
            label.setBorder(BorderFactory.createEmptyBorder(0, icon == null ? 5 : 0, 0, 5));
            TabButton button = new TabButton();
            this.add(button);
            this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        }

        private class TabButton
        extends JButton
        implements ActionListener {
            protected static final int SIZE = 16;

            public TabButton() {
                this.setPreferredSize(new Dimension(16, 16));
                this.setContentAreaFilled(false);
                this.setFocusable(false);
                this.setBorder(BorderFactory.createEtchedBorder());
                this.setBorderPainted(false);
                this.addMouseListener(TabComponent.this.buttonMouseListener);
                this.setRolloverEnabled(true);
                this.addActionListener(this);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = ((TabComponent)TabComponent.this).DefaultSelectedPanel.this.tabs.indexOfTabComponent(TabComponent.this);
                if (i != -1) {
                    ((TabComponent)TabComponent.this).DefaultSelectedPanel.this.selectedModules.remove(TabComponent.this.module);
                }
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                if (this.getModel().isPressed()) {
                    g2.translate(1, 1);
                }
                g2.setStroke(new BasicStroke(2.0f));
                g2.setColor(Color.RED);
                int delta = 5;
                g2.drawLine(delta, delta, this.getWidth() - delta - 2, this.getHeight() - delta - 2);
                g2.drawLine(this.getWidth() - delta - 2, delta, delta, this.getHeight() - delta - 2);
                g2.dispose();
            }
        }
    }

    protected class TabbedPane
    extends JTabbedPane {
        protected TabbedPane() {
        }

        @Override
        public void remove(int index) {
            Component component = DefaultSelectedPanel.this.tabs.getComponentAt(index);
            super.remove(index);
            if (component instanceof MyScrollPane) {
                MyScrollPane scroll = (MyScrollPane)component;
                DefaultSelectedPanel.this.map.remove(scroll.getPanel().getModule());
            }
        }

        protected int getIndex(PropertyModule module) {
            if (DefaultSelectedPanel.this.map.keySet().contains(module)) {
                int i = 0;
                while (i < DefaultSelectedPanel.this.tabs.getTabCount()) {
                    MyScrollPane scroll;
                    Component component = DefaultSelectedPanel.this.tabs.getComponentAt(i);
                    if (component instanceof MyScrollPane && (scroll = (MyScrollPane)component).getPanel().getModule().equals(module)) {
                        return i;
                    }
                    ++i;
                }
            }
            return -1;
        }
    }
}

