/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.config.visualization;

import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import org.opt4j.config.ExecutionEnvironment;
import org.opt4j.config.Icons;
import org.opt4j.config.visualization.ContentPanel;
import org.opt4j.config.visualization.ModulesPanel;
import org.opt4j.config.visualization.SelectedPanel;
import org.opt4j.config.visualization.TasksPanel;

public class DefaultContentPanel
extends ContentPanel {
    protected final ExecutionEnvironment executionEnvironment;
    protected final ModulesPanel modulesPanel;
    protected final SelectedPanel selectedPanel;
    protected final TasksPanel tasksPanel;

    @Inject
    public DefaultContentPanel(ExecutionEnvironment executionEnvironment, ModulesPanel modulesPanel, SelectedPanel selectedPanel, TasksPanel tasksPanel) {
        this.executionEnvironment = executionEnvironment;
        this.modulesPanel = modulesPanel;
        this.selectedPanel = selectedPanel;
        this.tasksPanel = tasksPanel;
    }

    @Override
    public void startup() {
        this.setLayout(new BorderLayout());
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setOneTouchExpandable(true);
        splitPane.setResizeWeight(1.0);
        this.add(splitPane);
        this.modulesPanel.setPreferredSize(new Dimension(220, 200));
        this.selectedPanel.setPreferredSize(new Dimension(350, 200));
        JPanel top = new JPanel(new BorderLayout());
        top.add((Component)this.modulesPanel, "West");
        top.add((Component)this.selectedPanel, "Center");
        JTabbedPane bottom = new JTabbedPane();
        bottom.addTab("Tasks", Icons.getIcon("icons/console.png"), this.tasksPanel);
        bottom.setPreferredSize(new Dimension(300, 160));
        top.setMinimumSize(new Dimension(300, 80));
        splitPane.add((Component)top, "top");
        splitPane.add((Component)bottom, "bottom");
        this.modulesPanel.startup();
        this.selectedPanel.startup();
        this.tasksPanel.startup();
        this.setVisible(true);
    }
}

