/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.config.visualization;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.opt4j.config.Icons;
import org.opt4j.config.visualization.About;
import org.opt4j.config.visualization.ApplicationFrame;
import org.opt4j.config.visualization.ContentPanel;
import org.opt4j.config.visualization.FileOperations;
import org.opt4j.config.visualization.Menu;
import org.opt4j.config.visualization.ToolBar;

@Singleton
public class DefaultApplicationFrame
extends ApplicationFrame {
    protected final ContentPanel contentPanel;
    protected final About about;
    protected final ToolBar toolBar;
    protected final Menu menu;
    protected final FileOperations fileOperations;
    protected String title = "Opt4J @VERSION@ Configurator";

    @Inject
    public DefaultApplicationFrame(ContentPanel panel, About about, Menu menu, ToolBar toolBar, FileOperations fileOperations) throws HeadlessException {
        this.contentPanel = panel;
        this.about = about;
        this.menu = menu;
        this.toolBar = toolBar;
        this.fileOperations = fileOperations;
    }

    @Inject
    public void init() {
        this.fileOperations.addListener(this);
    }

    @Override
    public void startup() {
        WindowAdapter exitListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Window window = e.getWindow();
                window.setVisible(false);
                window.dispose();
                try {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        System.exit(0);
                    }
                }
                finally {
                    System.exit(0);
                }
            }
        };
        this.addWindowListener(exitListener);
        this.setIconImage(Icons.getIcon("icons/logo2.png").getImage());
        this.setTitle(this.title);
        this.setLayout(new BorderLayout());
        JSeparator jSeparator = new JSeparator();
        JPanel toolBarPanel = new JPanel(new BorderLayout());
        toolBarPanel.add((Component)this.toolBar, "Center");
        toolBarPanel.add((Component)jSeparator, "South");
        this.add((Component)toolBarPanel, "North");
        this.add((Component)this.contentPanel, "Center");
        this.setJMenuBar(this.menu);
        this.menu.startup();
        this.toolBar.startup();
        this.contentPanel.startup();
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void setCurrentFile(final File file) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultApplicationFrame.this.setTitle(String.valueOf(DefaultApplicationFrame.this.title) + " [" + file.getCanonicalPath() + "]");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

