/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.config;

import com.google.inject.Module;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.opt4j.config.JNode;
import org.opt4j.config.PropertyModule;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ModuleSaver {
    public boolean save(String filename, Collection<? extends Module> modules) {
        File file = new File(filename);
        return this.save(file, modules);
    }

    public boolean save(File file, Collection<? extends Module> modules) {
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element node = document.createElement("application");
            document.appendChild(node);
            this.add(node, modules);
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setAttribute("indent-number", 2);
            Transformer trans = tf.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.setOutputProperty("indent", "yes");
            trans.setOutputProperty("method", "xml");
            FileOutputStream out = new FileOutputStream(file);
            StreamResult result = new StreamResult(new OutputStreamWriter((OutputStream)out, "utf-8"));
            DOMSource source = new DOMSource(document);
            trans.transform(source, result);
            return true;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return false;
    }

    public void add(Node node, Collection<? extends Module> modules) {
        JNode parent = new JNode(node);
        for (Module module : modules) {
            PropertyModule pModule = module instanceof PropertyModule ? (PropertyModule)module : new PropertyModule(module);
            JNode n = new JNode(pModule.getConfiguration(parent.getDocument()));
            parent.appendChild(n);
        }
    }
}

