/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.common.logger;

import com.google.inject.Inject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.opt4j.common.logger.AbstractLogger;
import org.opt4j.common.logger.Logger;
import org.opt4j.core.Archive;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualBuilder;
import org.opt4j.core.Objective;
import org.opt4j.core.Objectives;
import org.opt4j.core.Value;
import org.opt4j.core.optimizer.Optimizer;
import org.opt4j.core.problem.Evaluator;
import org.opt4j.start.Constant;

public class NDLogger
extends AbstractLogger
implements Logger {
    protected final Archive archive;
    protected final Evaluator<?> evaluator;
    private final PrintWriter out;
    private long timeOffset;
    private SortedSet<Objective> sortedSet = new TreeSet<Objective>(new Comparator<Objective>(){

        @Override
        public int compare(Objective o1, Objective o2) {
            return o1.getName().compareTo(o2.getName());
        }
    });

    @Inject
    public NDLogger(Optimizer optimizer, IndividualBuilder individualBuilder, Archive archive, Evaluator evaluator, @Constant(value="filename", namespace=NDLogger.class) String filename, @Constant(value="evaluationStep", namespace=NDLogger.class) int evaluationStep, @Constant(value="iterationStep", namespace=NDLogger.class) int iterationStep) {
        super(optimizer, individualBuilder, iterationStep, evaluationStep);
        this.archive = archive;
        this.evaluator = evaluator;
        if (filename == null || filename.equals("")) {
            throw new IllegalArgumentException("Filename must not be the empty string.");
        }
        try {
            File file = new File(filename);
            File dir = file.getParentFile();
            if (dir != null) {
                dir.mkdirs();
            }
            file.createNewFile();
            this.out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void logEvent(int iteration, int evaluation) {
        double seconds = ((double)System.currentTimeMillis() - (double)this.timeOffset) / 1000.0;
        for (Individual individual : this.archive) {
            this.out.print(String.valueOf(iteration) + "\t" + evaluation + "\t" + seconds);
            Objectives objectives = individual.getObjectives();
            for (Objective objective : this.sortedSet) {
                Value<?> value = objectives.get(objective);
                this.out.print("\t" + value.getValue());
            }
            this.out.println();
        }
        this.out.flush();
    }

    @Override
    public void optimizationStarted() {
        this.sortedSet.addAll(this.evaluator.getObjectives());
        this.out.print("#generations\tevaluations\truntime[s]");
        for (Objective objective : this.sortedSet) {
            this.out.print("\t" + objective.getName());
        }
        this.out.println();
        this.out.print("#-\t-\t-");
        for (Objective objective : this.sortedSet) {
            this.out.print("\t" + (Object)((Object)objective.getSign()));
        }
        this.out.println();
        this.timeOffset = System.currentTimeMillis();
    }

    @Override
    public void optimizationStopped() {
        this.out.close();
    }
}

