/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.common.logger;

import com.google.inject.Inject;
import java.util.concurrent.atomic.AtomicInteger;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualBuilder;
import org.opt4j.core.IndividualStateListener;
import org.opt4j.core.optimizer.Optimizer;
import org.opt4j.core.optimizer.OptimizerIterationListener;
import org.opt4j.core.optimizer.OptimizerStateListener;

public abstract class AbstractLogger
implements OptimizerStateListener,
OptimizerIterationListener,
IndividualStateListener {
    protected int iterationStep;
    protected int evaluationStep;
    protected int evaluationCountLast = 0;
    protected AtomicInteger evaluationCount = new AtomicInteger(0);
    protected final IndividualBuilder individualBuilder;

    public AbstractLogger(Optimizer optimizer, IndividualBuilder individualBuilder, int iterationStep, int evaluationStep) {
        this.individualBuilder = individualBuilder;
        this.iterationStep = iterationStep;
        this.evaluationStep = evaluationStep;
    }

    @Inject
    public void init() {
        this.individualBuilder.addIndividualStateListener(this);
    }

    public abstract void logEvent(int var1, int var2);

    public abstract void optimizationStarted();

    public abstract void optimizationStopped();

    @Override
    public void iterationComplete(Optimizer optimizer, int iteration) {
        boolean logIteration = false;
        if (this.iterationStep > 0) {
            logIteration = iteration % this.iterationStep == 0;
        }
        boolean logEvaluation = false;
        if (this.evaluationStep > 0) {
            boolean bl = logEvaluation = this.evaluationCount.intValue() - this.evaluationCountLast >= this.evaluationStep;
        }
        if (logEvaluation) {
            do {
                this.evaluationCountLast += this.evaluationStep;
            } while (this.evaluationCount.intValue() - this.evaluationCountLast >= this.evaluationStep);
        }
        if (logIteration || logEvaluation) {
            this.logEvent(iteration, this.evaluationCount.intValue());
        }
    }

    @Override
    public void optimizationStarted(Optimizer optimizer) {
        this.optimizationStarted();
    }

    @Override
    public void optimizationStopped(Optimizer optimizer) {
        this.optimizationStopped();
    }

    @Override
    public void inidividualStateChanged(Individual individual) {
        if (individual.getState() == Individual.State.EVALUATED) {
            this.evaluationCount.incrementAndGet();
        }
    }
}

