/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.common.completer;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import org.opt4j.core.IncompatibilityException;
import org.opt4j.core.Individual;
import org.opt4j.core.Objectives;
import org.opt4j.core.optimizer.Completer;
import org.opt4j.core.optimizer.Control;
import org.opt4j.core.optimizer.TerminationException;
import org.opt4j.core.problem.Decoder;
import org.opt4j.core.problem.Evaluator;
import org.opt4j.core.problem.Genotype;
import org.opt4j.core.problem.Phenotype;

public class SequentialCompleter
implements Completer {
    protected final Decoder<Genotype, Phenotype> decoder;
    protected final Evaluator<Phenotype> evaluator;
    protected final Control control;

    @Inject
    public SequentialCompleter(Control control, Decoder decoder, Evaluator evaluator) {
        this.control = control;
        this.decoder = decoder;
        this.evaluator = evaluator;
    }

    @Override
    public void complete(Iterable<? extends Individual> iterable) throws TerminationException {
        for (Individual individual : iterable) {
            if (individual.isEvaluated()) continue;
            this.control.checkpoint();
            this.decode(individual);
            this.control.checkpoint();
            this.evaluate(individual);
            this.control.checkpoint();
        }
    }

    @Override
    public void complete(Individual ... individuals) throws TerminationException {
        List<Individual> list = Arrays.asList(individuals);
        this.complete(list);
    }

    protected void evaluate(Individual individual) {
        Objectives objectives;
        Individual.State state = individual.getState();
        if (state == Individual.State.PHENOTYPED) {
            individual.setState(Individual.State.EVALUATING);
            Phenotype phenotype = individual.getPhenotype();
            objectives = this.evaluator.evaluate(phenotype);
            if (objectives.size() != this.evaluator.getObjectives().size() || !objectives.getKeys().containsAll(this.evaluator.getObjectives())) {
                throw new IncompatibilityException("Incompatible objectives: Evaluator should set following objectives: " + this.evaluator.getObjectives() + ". But actually " + objectives.getKeys() + " are set.");
            }
        } else {
            throw new IllegalStateException("Cannot evaluate Individual, current state: " + (Object)((Object)state));
        }
        individual.setObjectives(objectives);
    }

    protected void decode(Individual individual) {
        Individual.State state = individual.getState();
        if (state != Individual.State.GENOTYPED) {
            throw new IllegalStateException("Cannot decode Individual, current state: " + (Object)((Object)state));
        }
        individual.setState(Individual.State.DECODING);
        Genotype genotype = individual.getGenotype();
        Phenotype phenotype = this.decoder.decode(genotype);
        individual.setPhenotype(phenotype);
    }
}

