/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.common.completer;

import com.google.inject.internal.Preconditions;
import org.opt4j.common.completer.ParallelCompleter;
import org.opt4j.common.completer.SequentialCompleter;
import org.opt4j.config.annotations.Icon;
import org.opt4j.config.annotations.Info;
import org.opt4j.config.annotations.Required;
import org.opt4j.core.optimizer.Completer;
import org.opt4j.start.Constant;
import org.opt4j.start.Opt4JModule;

@Icon(value="icons/puzzle-blue.png")
@Info(value="The Completer decodes and evaluates the individuals in the optimization process.")
public class CompleterModule
extends Opt4JModule {
    @Info(value="Sets the type of the completer.")
    protected Type type = Type.SEQUENTIAL;
    @Info(value="Sets the numer of maximal parallel processes.")
    @Required(property="type", elements={"PARALLEL"})
    @Constant(value="maxThreads", namespace=ParallelCompleter.class)
    protected int threads = 4;

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        Preconditions.checkState((threads > 0 ? 1 : 0) != 0, (String)"The number of threads must be positive: %s", (Object[])new Object[]{threads});
        this.threads = threads;
    }

    @Override
    public void config() {
        switch (this.type) {
            case SEQUENTIAL: {
                this.bind(Completer.class).to(SequentialCompleter.class).in(SINGLETON);
                break;
            }
            default: {
                this.bind(ParallelCompleter.class).in(SINGLETON);
                this.bind(Completer.class).to(ParallelCompleter.class);
                this.addOptimizerStateListener(ParallelCompleter.class);
            }
        }
    }

    public static enum Type {
        SEQUENTIAL,
        PARALLEL;

    }
}

