/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.common.archive;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opt4j.common.archive.BoundedArchive;
import org.opt4j.core.Individual;
import org.opt4j.start.Constant;

public class CrowdingArchive
extends BoundedArchive {
    @Inject
    public CrowdingArchive(@Constant(value="capacity", namespace=BoundedArchive.class) int capacity) {
        super(capacity);
    }

    @Override
    protected void updateWithNondominated(Collection<Individual> candidates) {
        if (this.size() + candidates.size() <= this.capacity) {
            this.addAll((Collection<? extends Individual>)candidates);
        } else {
            candidates.addAll(this);
            Map<Individual, Double> map = this.getValues(candidates);
            List<Individual> list = this.order(map);
            List<Individual> worst = list.subList(this.capacity, list.size());
            candidates.removeAll(worst);
            this.retainAll(candidates);
            for (Individual i : candidates) {
                if (this.contains(i)) continue;
                this.add(i);
            }
        }
    }

    public Map<Individual, Double> getValues(Collection<Individual> individuals) {
        HashMap<Individual, Double> map = new HashMap<Individual, Double>();
        ArrayList<Individual> list = new ArrayList<Individual>(individuals);
        for (Individual individual : list) {
            map.put(individual, 0.0);
        }
        int m = ((Individual)list.get(0)).getObjectives().array().length;
        int i = 0;
        while (i < m) {
            final int d = i;
            Collections.sort(list, new Comparator<Individual>(){

                @Override
                public int compare(Individual o1, Individual o2) {
                    double i1 = o1.getObjectives().array()[d];
                    double i2 = o2.getObjectives().array()[d];
                    return (int)Math.signum(i1 - i2);
                }
            });
            map.put((Individual)list.get(0), (Double)Double.MAX_VALUE);
            map.put((Individual)list.get(list.size() - 1), (Double)Double.MAX_VALUE);
            int j = 1;
            while (j < list.size() - 1) {
                double p = ((Individual)list.get(j - 1)).getObjectives().array()[i];
                double n = ((Individual)list.get(j + 1)).getObjectives().array()[i];
                Individual ind = (Individual)list.get(j);
                map.put(ind, (Double)map.get(ind) + (n - p));
                ++j;
            }
            ++i;
        }
        return map;
    }

    public List<Individual> order(final Map<Individual, Double> values) {
        ArrayList<Individual> list = new ArrayList<Individual>(values.keySet());
        Collections.sort(list, new Comparator<Individual>(){

            @Override
            public int compare(Individual o1, Individual o2) {
                double i1 = (Double)values.get(o1);
                double i2 = (Double)values.get(o2);
                return (int)Math.signum(i2 - i1);
            }
        });
        return list;
    }
}

