/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.common.archive;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import org.opt4j.common.archive.AbstractArchive;
import org.opt4j.core.Individual;

public abstract class BoundedArchive
extends AbstractArchive {
    protected int capacity;

    @Inject
    public BoundedArchive(int capacity) {
        this.capacity = capacity;
        if (capacity < 0) {
            throw new IllegalArgumentException("Invalid capacity: " + capacity);
        }
    }

    public void setCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Invalid capacity: " + capacity);
        }
        this.capacity = capacity;
    }

    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public boolean add(Individual individual) {
        if (!this.contains(individual) && this.individuals.size() >= this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        return super.add(individual);
    }

    @Override
    public boolean addAll(Collection<? extends Individual> c) {
        HashSet<? extends Individual> set = new HashSet<Individual>(c);
        set.removeAll(this);
        if (this.individuals.size() + set.size() > this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        boolean b = false;
        for (Individual individual : c) {
            b |= super.add(individual);
        }
        return b;
    }
}

