/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.common.archive;

import org.opt4j.common.archive.AdaptiveGridArchive;
import org.opt4j.common.archive.BoundedArchive;
import org.opt4j.common.archive.CrowdingArchive;
import org.opt4j.common.archive.PopulationArchive;
import org.opt4j.common.archive.UnboundedArchive;
import org.opt4j.config.annotations.Icon;
import org.opt4j.config.annotations.Info;
import org.opt4j.config.annotations.Required;
import org.opt4j.core.Archive;
import org.opt4j.start.Constant;
import org.opt4j.start.Opt4JModule;

@Icon(value="icons/puzzle-blue.png")
@Info(value="The archive of non-dominated solutions found while the optimization process.")
public class ArchiveModule
extends Opt4JModule {
    @Info(value="Archive type")
    protected Type type = Type.CROWDING;
    @Info(value="Maximal archive capacity if a bounded archive is selected")
    @Required(property="type", elements={"ADAPTIVE_GRID", "CROWDING"})
    @Constant(value="capacity", namespace=BoundedArchive.class)
    protected int capacity = 100;
    @Info(value="Divisions for the adaptive grid archive. A convergence is guaranteed if 'capacity>1+div^m+(div-1)^m+2*m' with m being the number of objectives holds")
    @Required(property="type", elements={"ADAPTIVE_GRID"})
    @Constant(value="div", namespace=AdaptiveGridArchive.class)
    protected int divisions = 7;

    public int getDivisions() {
        return this.divisions;
    }

    public void setDivisions(int divisions) {
        this.divisions = divisions;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public void config() {
        Class archiveClass = null;
        switch (this.type) {
            case ADAPTIVE_GRID: {
                archiveClass = AdaptiveGridArchive.class;
                break;
            }
            case POPULATION: {
                archiveClass = PopulationArchive.class;
                break;
            }
            case CROWDING: {
                archiveClass = CrowdingArchive.class;
                break;
            }
            default: {
                archiveClass = UnboundedArchive.class;
            }
        }
        this.bind(Archive.class).to(archiveClass).in(SINGLETON);
    }

    public static enum Type {
        UNBOUNDED,
        POPULATION,
        ADAPTIVE_GRID,
        CROWDING;

    }
}

