/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.benchmark.zdt;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.opt4j.core.Objective;
import org.opt4j.core.Objectives;
import org.opt4j.core.problem.Evaluator;
import org.opt4j.core.problem.Phenotype;

abstract class ZDTEvaluator<A extends Phenotype>
implements Evaluator<A> {
    protected final Objective f1obj = new Objective("f1", Objective.Sign.MIN);
    protected final Objective f2obj = new Objective("f2", Objective.Sign.MIN);
    protected final List<Objective> objectives = Arrays.asList(this.f1obj, this.f2obj);

    ZDTEvaluator() {
    }

    protected abstract double f1(A var1);

    protected double f2(double g, double h) {
        return g * h;
    }

    protected abstract double g(A var1);

    protected abstract double h(double var1, double var3);

    @Override
    public Objectives evaluate(A x) {
        double f1 = this.f1(x);
        double g = this.g(x);
        double h = this.h(f1, g);
        double f2 = this.f2(g, h);
        Objectives objectives = new Objectives(f1, f2){
            {
                this.add(ZDTEvaluator.this.f1obj, d);
                this.add(ZDTEvaluator.this.f2obj, d2);
            }
        };
        return objectives;
    }

    @Override
    public Collection<Objective> getObjectives() {
        return this.objectives;
    }
}

