/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.benchmark.wfg;

import org.opt4j.benchmark.BinaryCreator;
import org.opt4j.benchmark.BinaryToDoubleDecoder;
import org.opt4j.benchmark.Bits;
import org.opt4j.benchmark.DoubleCopyDecoder;
import org.opt4j.benchmark.DoubleCreator;
import org.opt4j.benchmark.K;
import org.opt4j.benchmark.M;
import org.opt4j.benchmark.N;
import org.opt4j.benchmark.wfg.WFG1;
import org.opt4j.benchmark.wfg.WFG2;
import org.opt4j.benchmark.wfg.WFG3;
import org.opt4j.benchmark.wfg.WFG4;
import org.opt4j.benchmark.wfg.WFG5;
import org.opt4j.benchmark.wfg.WFG6;
import org.opt4j.benchmark.wfg.WFG7;
import org.opt4j.benchmark.wfg.WFG8;
import org.opt4j.benchmark.wfg.WFG9;
import org.opt4j.benchmark.wfg.WFGI1;
import org.opt4j.benchmark.wfg.WFGI2;
import org.opt4j.benchmark.wfg.WFGI3;
import org.opt4j.benchmark.wfg.WFGI4;
import org.opt4j.benchmark.wfg.WFGI5;
import org.opt4j.config.annotations.Info;
import org.opt4j.config.annotations.Order;
import org.opt4j.config.annotations.Required;
import org.opt4j.core.problem.ProblemModule;

@Info(value="WFG Problem Suite. The number of search variables is n=k+l.")
public class WFGModule
extends ProblemModule {
    @Order(value=0)
    @Info(value="The WFG function.")
    protected Function function = Function.WFG1;
    @Order(value=2)
    @Info(value="The number of objectives.")
    protected int m = 2;
    @Order(value=3)
    @Info(value="The number of distance parameters. (suggested: l=4 for m=2, l=2*(m-1) for m>2)")
    protected int k = 6;
    @Order(value=4)
    @Info(value="The number of position parameters. (k%(m-1)=0)")
    protected int l = 4;
    @Required(property="encoding", elements={"BINARY"})
    @Info(value="The number of bits per double value.")
    protected int bits = 30;
    @Order(value=10)
    @Info(value="The encoding of the optimization problem.")
    protected Encoding encoding = Encoding.DOUBLE;

    public int getBits() {
        return this.bits;
    }

    public void setBits(int bits) {
        this.bits = bits;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Encoding encoding) {
        this.encoding = encoding;
    }

    public Function getFunction() {
        return this.function;
    }

    public void setFunction(Function function) {
        this.function = function;
    }

    public int getL() {
        return this.l;
    }

    public void setL(int l) {
        assert (l > 0);
        this.l = this.function == Function.WFG2 || this.function == Function.WFG3 ? (int)Math.ceil((double)l / 2.0) * 2 : l;
    }

    public int getM() {
        return this.m;
    }

    public void setM(int m) {
        assert (m >= 2);
        this.m = m;
        if (m == 2) {
            this.setL(4);
        } else {
            this.setL(2 * (m - 1));
        }
        this.setK(this.k);
    }

    public int getK() {
        return this.k;
    }

    public void setK(int k) {
        assert (k > 0);
        if (k % (this.m - 1) == 0) {
            this.k = k;
        } else {
            double div = (double)k / (double)(this.m - 1);
            this.k = (this.m - 1) * (int)Math.ceil(div);
        }
    }

    @Override
    public void config() {
        Class creator = null;
        Class decoder = null;
        Class evaluator = null;
        switch (this.encoding) {
            case BINARY: {
                creator = BinaryCreator.class;
                decoder = BinaryToDoubleDecoder.class;
                break;
            }
            case DOUBLE: {
                creator = DoubleCreator.class;
                decoder = DoubleCopyDecoder.class;
            }
        }
        switch (this.function) {
            default: {
                evaluator = WFG1.class;
                break;
            }
            case WFG2: {
                evaluator = WFG2.class;
                break;
            }
            case WFG3: {
                evaluator = WFG3.class;
                break;
            }
            case WFG4: {
                evaluator = WFG4.class;
                break;
            }
            case WFG5: {
                evaluator = WFG5.class;
                break;
            }
            case WFG6: {
                evaluator = WFG6.class;
                break;
            }
            case WFG7: {
                evaluator = WFG7.class;
                break;
            }
            case WFG8: {
                evaluator = WFG8.class;
                break;
            }
            case WFG9: {
                evaluator = WFG9.class;
                break;
            }
            case I1: {
                evaluator = WFGI1.class;
                break;
            }
            case I2: {
                evaluator = WFGI2.class;
                break;
            }
            case I3: {
                evaluator = WFGI3.class;
                break;
            }
            case I4: {
                evaluator = WFGI4.class;
                break;
            }
            case I5: {
                evaluator = WFGI5.class;
            }
        }
        this.bindConstant(N.class).to(this.k + this.l);
        this.bindConstant(M.class).to(this.m);
        this.bindConstant(K.class).to(this.k);
        this.bindConstant(Bits.class).to(this.bits);
        this.bindProblem(creator, decoder, evaluator);
    }

    public static enum Encoding {
        DOUBLE,
        BINARY;

    }

    public static enum Function {
        WFG1,
        WFG2,
        WFG3,
        WFG4,
        WFG5,
        WFG6,
        WFG7,
        WFG8,
        WFG9,
        I1,
        I2,
        I3,
        I4,
        I5;

    }
}

