/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.benchmark.wfg;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opt4j.benchmark.DoubleString;
import org.opt4j.benchmark.K;
import org.opt4j.benchmark.M;
import org.opt4j.core.Objective;
import org.opt4j.core.Objectives;
import org.opt4j.core.problem.Evaluator;

public abstract class WFGEvaluator
implements Evaluator<DoubleString> {
    protected final int M;
    protected final int k;
    protected final List<Objective> keys = new ArrayList<Objective>();

    @Inject
    public WFGEvaluator(@K int k, @M int M2) {
        this.M = M2;
        this.k = k;
        int i = 0;
        while (i < M2) {
            this.keys.add(new Objective("f" + (i + 1)));
            ++i;
        }
    }

    public abstract List<Double> f(List<Double> var1);

    @Override
    public Objectives evaluate(DoubleString phenotype) {
        List<Double> f = this.f(phenotype);
        assert (f.size() == this.keys.size());
        Objectives objectives = new Objectives();
        int i = 0;
        while (i < this.M) {
            objectives.add(this.keys.get(i), f.get(i));
            ++i;
        }
        return objectives;
    }

    @Override
    public Collection<Objective> getObjectives() {
        return this.keys;
    }

    protected static List<Boolean> createA(int M2, boolean degenerate) {
        assert (M2 >= 2);
        ArrayList<Boolean> A = new ArrayList<Boolean>();
        int i = 0;
        while (i < M2 - 1) {
            if (!degenerate || i == 1) {
                A.add(true);
            } else {
                A.add(false);
            }
            ++i;
        }
        return A;
    }

    protected static List<Double> calculateF(List<Double> x, List<Double> h) {
        assert (x.size() == h.size());
        int M2 = h.size();
        ArrayList<Double> S = new ArrayList<Double>();
        int m = 1;
        while (m <= M2) {
            S.add((double)m * 2.0);
            ++m;
        }
        return WFGEvaluator.caculateF(x, h, S);
    }

    protected static List<Double> normalizeZ(List<Double> z, List<Double> z_max) {
        ArrayList<Double> result = new ArrayList<Double>();
        int i = 0;
        while (i < z.size()) {
            assert (z.get(i) >= 0.0);
            assert (z.get(i) <= z_max.get(i));
            assert (z_max.get(i) > 0.0);
            result.add(z.get(i) / z_max.get(i));
            ++i;
        }
        return result;
    }

    protected static List<Double> calculateX(List<Double> t_p, List<Boolean> A) {
        int size = t_p.size();
        assert (size != 0);
        assert (A.size() == t_p.size() - 1);
        ArrayList<Double> result = new ArrayList<Double>();
        int i = 0;
        while (i < t_p.size() - 1) {
            boolean A_i = A.get(i) != false;
            double tmp1 = Math.max(t_p.get(size - 1), (double)A_i);
            result.add(tmp1 * (t_p.get(i) - 0.5) + 0.5);
            ++i;
        }
        result.add(t_p.get(size - 1));
        return result;
    }

    protected static List<Double> caculateF(List<Double> x, List<Double> h, List<Double> S) {
        assert (x.size() == h.size());
        assert (h.size() == S.size());
        ArrayList<Double> result = new ArrayList<Double>();
        int i = 0;
        while (i < h.size()) {
            assert (S.get(i) > 0.0);
            result.add(x.get(x.size() - 1) + S.get(i) * h.get(i));
            ++i;
        }
        return result;
    }
}

