/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.benchmark.wfg;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.opt4j.benchmark.K;
import org.opt4j.benchmark.M;
import org.opt4j.benchmark.wfg.WFGEvaluator;
import org.opt4j.benchmark.wfg.WFGShapeFunctions;
import org.opt4j.benchmark.wfg.WFGTransFunctions;

public class WFG1
extends WFGEvaluator {
    @Inject
    public WFG1(@K int k, @M int M2) {
        super(k, M2);
    }

    protected static List<Double> t1(List<Double> y, int k) {
        int n = y.size();
        assert (k >= 1);
        assert (k < n);
        ArrayList<Double> t = new ArrayList<Double>();
        int i = 0;
        while (i < k) {
            t.add(y.get(i));
            ++i;
        }
        i = k;
        while (i < n) {
            t.add(WFGTransFunctions.s_linear(y.get(i), 0.35));
            ++i;
        }
        return t;
    }

    protected static List<Double> t2(List<Double> y, int k) {
        int n = y.size();
        assert (k >= 1);
        assert (k < n);
        ArrayList<Double> t = new ArrayList<Double>();
        int i = 0;
        while (i < k) {
            t.add(y.get(i));
            ++i;
        }
        i = k;
        while (i < n) {
            t.add(WFGTransFunctions.b_flat(y.get(i), 0.8, 0.75, 0.85));
            ++i;
        }
        return t;
    }

    protected static List<Double> t3(List<Double> y) {
        int n = y.size();
        ArrayList<Double> t = new ArrayList<Double>();
        int i = 0;
        while (i < n) {
            t.add(WFGTransFunctions.b_poly(y.get(i), 0.02));
            ++i;
        }
        return t;
    }

    protected static List<Double> t4(List<Double> y, int k, int M2) {
        int n = y.size();
        assert (k >= 1);
        assert (k < n);
        assert (M2 >= 2);
        assert (k % (M2 - 1) == 0);
        ArrayList<Double> w = new ArrayList<Double>();
        int i = 1;
        while (i <= n) {
            w.add(2.0 * (double)i);
            ++i;
        }
        ArrayList<Double> t = new ArrayList<Double>();
        int i2 = 1;
        while (i2 <= M2 - 1) {
            int head = (i2 - 1) * k / (M2 - 1);
            int tail = i2 * k / (M2 - 1);
            List<Double> y_sub = y.subList(head, tail);
            List<Double> w_sub = w.subList(head, tail);
            t.add(WFGTransFunctions.r_sum(y_sub, w_sub));
            ++i2;
        }
        List<Double> y_sub = y.subList(k, n);
        List<Double> w_sub = w.subList(k, n);
        t.add(WFGTransFunctions.r_sum(y_sub, w_sub));
        return t;
    }

    protected static List<Double> shape(List<Double> t_p) {
        assert (t_p.size() >= 2);
        int M2 = t_p.size();
        List<Boolean> A = WFG1.createA(M2, false);
        List<Double> x = WFG1.calculateX(t_p, A);
        ArrayList<Double> h = new ArrayList<Double>();
        int m = 1;
        while (m <= M2 - 1) {
            h.add(WFGShapeFunctions.convex(x, m));
            ++m;
        }
        h.add(WFGShapeFunctions.mixed(x, 5, 1.0));
        return WFG1.calculateF(x, h);
    }

    @Override
    public List<Double> f(List<Double> y) {
        y = WFG1.t1(y, this.k);
        y = WFG1.t2(y, this.k);
        y = WFG1.t3(y);
        y = WFG1.t4(y, this.k, this.M);
        return WFG1.shape(y);
    }
}

