/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.benchmark.queens;

import com.google.inject.Inject;
import java.util.Set;
import org.opt4j.benchmark.queens.QueensBoard;
import org.opt4j.benchmark.queens.QueensProblem;
import org.opt4j.common.random.Rand;
import org.opt4j.core.problem.Genotype;
import org.opt4j.sat.AbstractSATDecoder;
import org.opt4j.sat.Constraint;
import org.opt4j.sat.Literal;
import org.opt4j.sat.Model;
import org.opt4j.sat.SATManager;

public class QueensSATDecoder
extends AbstractSATDecoder<Genotype, QueensBoard> {
    protected final QueensProblem problem;

    @Inject
    public QueensSATDecoder(SATManager manager, QueensProblem problem, Rand random) {
        super(manager, random);
        this.problem = problem;
    }

    @Override
    public QueensBoard convertModel(Model model) {
        int size = this.problem.size();
        QueensBoard queensBoard = new QueensBoard(size);
        int i = 0;
        while (i < size) {
            int j = 0;
            while (j < size) {
                queensBoard.setQueen(i, j, model.get(i * size + j));
                ++j;
            }
            ++i;
        }
        return queensBoard;
    }

    @Override
    public void init(Set<Constraint> constraints) {
        int i;
        int j;
        Constraint constraint;
        int size = this.problem.size();
        int i2 = 0;
        while (i2 < size) {
            constraint = new Constraint("=", 1);
            j = 0;
            while (j < size) {
                constraint.add(new Literal(i2 * size + j, true));
                ++j;
            }
            constraints.add(constraint);
            ++i2;
        }
        int j2 = 0;
        while (j2 < size) {
            constraint = new Constraint("=", 1);
            int i3 = 0;
            while (i3 < size) {
                constraint.add(new Literal(i3 * size + j2, true));
                ++i3;
            }
            constraints.add(constraint);
            ++j2;
        }
        int k = -size + 1;
        while (k < size) {
            constraint = new Constraint("<=", 1);
            j = 0;
            while (j < size) {
                i = k + j;
                if (i >= 0 && i < size) {
                    constraint.add(new Literal(i * size + j, true));
                }
                ++j;
            }
            constraints.add(constraint);
            ++k;
        }
        k = 0;
        while (k < 2 * size - 1) {
            constraint = new Constraint("<=", 1);
            j = 0;
            while (j < size) {
                i = k - j;
                if (i >= 0 && i < size) {
                    constraint.add(new Literal(i * size + j, true));
                }
                ++j;
            }
            constraints.add(constraint);
            ++k;
        }
    }
}

