/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.benchmark.queens;

import com.google.inject.Inject;
import java.util.Random;
import org.opt4j.benchmark.queens.QueensBoard;
import org.opt4j.benchmark.queens.QueensProblem;
import org.opt4j.common.random.Rand;
import org.opt4j.core.problem.Creator;
import org.opt4j.core.problem.Decoder;
import org.opt4j.genotype.PermutationGenotype;

public class QueensPermutationDecoder
implements Decoder<PermutationGenotype<Integer>, QueensBoard>,
Creator<PermutationGenotype<Integer>> {
    protected final QueensProblem problem;
    protected final Random random;

    @Inject
    public QueensPermutationDecoder(QueensProblem problem, Rand random) {
        this.problem = problem;
        this.random = random;
    }

    @Override
    public PermutationGenotype<Integer> create() {
        int size = this.problem.size();
        PermutationGenotype<Integer> genotype = new PermutationGenotype<Integer>();
        int i = 0;
        while (i < size) {
            genotype.add(i);
            ++i;
        }
        genotype.init(this.random);
        return genotype;
    }

    @Override
    public QueensBoard decode(PermutationGenotype<Integer> permutation) {
        int size = this.problem.size();
        QueensBoard queensBoard = new QueensBoard(size);
        int i = 0;
        while (i < permutation.size()) {
            queensBoard.setQueen(i, (Integer)permutation.get(i), true);
            ++i;
        }
        return queensBoard;
    }
}

