/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.benchmark.queens;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opt4j.benchmark.queens.QueensBoard;
import org.opt4j.benchmark.queens.QueensProblem;
import org.opt4j.core.Objective;
import org.opt4j.core.Objectives;
import org.opt4j.core.problem.Evaluator;

public class QueensEvaluator
implements Evaluator<QueensBoard> {
    protected final QueensProblem problem;
    protected List<Objective> objectives = new ArrayList<Objective>();
    protected Objective error = new Objective("error", Objective.Sign.MIN, -100);

    @Inject
    public QueensEvaluator(QueensProblem problem) {
        this.problem = problem;
    }

    @Inject
    public void init() {
        int d = 0;
        while (d < this.problem.dim()) {
            this.objectives.add(new Objective("sum" + d, Objective.Sign.MIN));
            ++d;
        }
        this.objectives.add(this.error);
    }

    @Override
    public Objectives evaluate(QueensBoard queensBoard) {
        Objectives obj = new Objectives();
        int errors = this.countErrors(queensBoard);
        obj.add(this.error, errors);
        if (errors > 0) {
            obj.setFeasible(false);
        }
        int d = 0;
        while (d < this.problem.dim()) {
            Objective objective = this.objectives.get(d);
            if (errors == 0) {
                int sum = this.sum(queensBoard, d);
                obj.add(objective, sum);
            } else {
                obj.add(objective, Objective.INFEASIBLE);
            }
            ++d;
        }
        return obj;
    }

    private int sum(QueensBoard board, int d) {
        int sum = 0;
        int i = 0;
        while (i < this.problem.size()) {
            int j = 0;
            while (j < this.problem.size()) {
                if (board.isQueen(i, j)) {
                    sum += this.problem.costs(d, i, j);
                }
                ++j;
            }
            ++i;
        }
        return sum;
    }

    private int countErrors(QueensBoard queensBoard) {
        int i;
        int j;
        int sum;
        int errorcount = 0;
        int size = this.problem.size();
        int i2 = 0;
        while (i2 < size) {
            sum = 0;
            j = 0;
            while (j < size) {
                if (queensBoard.isQueen(i2, j)) {
                    ++sum;
                }
                ++j;
            }
            sum = Math.abs(1 - sum);
            errorcount += sum;
            sum = 0;
            j = 0;
            while (j < size) {
                if (queensBoard.isQueen(j, i2)) {
                    ++sum;
                }
                ++j;
            }
            sum = Math.abs(1 - sum);
            errorcount += sum;
            ++i2;
        }
        int k = -size + 1;
        while (k < size) {
            sum = 0;
            j = 0;
            while (j < size) {
                i = k + j;
                if (i >= 0 && i < size && queensBoard.isQueen(j, i)) {
                    ++sum;
                }
                ++j;
            }
            sum = Math.max(0, sum - 1);
            errorcount += sum;
            ++k;
        }
        k = 0;
        while (k < 2 * size - 1) {
            sum = 0;
            j = 0;
            while (j < size) {
                i = k - j;
                if (i >= 0 && i < size && queensBoard.isQueen(j, i)) {
                    ++sum;
                }
                ++j;
            }
            sum = Math.max(0, sum - 1);
            errorcount += sum;
            ++k;
        }
        return errorcount;
    }

    @Override
    public Collection<Objective> getObjectives() {
        return this.objectives;
    }
}

