/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.benchmark.queens;

import com.google.inject.Inject;
import java.util.Random;
import org.opt4j.benchmark.queens.QueensBoard;
import org.opt4j.benchmark.queens.QueensProblem;
import org.opt4j.common.random.Rand;
import org.opt4j.core.problem.Creator;
import org.opt4j.core.problem.Decoder;
import org.opt4j.genotype.BooleanGenotype;

public class QueensCopyDecoder
implements Decoder<BooleanGenotype, QueensBoard>,
Creator<BooleanGenotype> {
    protected final QueensProblem problem;
    protected final Random random;

    @Inject
    public QueensCopyDecoder(QueensProblem problem, Rand random) {
        this.problem = problem;
        this.random = random;
    }

    @Override
    public BooleanGenotype create() {
        int size = this.problem.size();
        BooleanGenotype vector = new BooleanGenotype();
        vector.init(this.random, size * size);
        return vector;
    }

    @Override
    public QueensBoard decode(BooleanGenotype vector) {
        int size = this.problem.size();
        QueensBoard queensBoard = new QueensBoard(size);
        int i = 0;
        while (i < size) {
            int j = 0;
            while (j < size) {
                queensBoard.setQueen(i, j, (Boolean)vector.get(i + j * size));
                ++j;
            }
            ++i;
        }
        return queensBoard;
    }
}

