/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.benchmark.lotz;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.opt4j.benchmark.BinaryString;
import org.opt4j.core.Objective;
import org.opt4j.core.Objectives;
import org.opt4j.core.problem.Evaluator;

public class LOTZEvaluator
implements Evaluator<BinaryString> {
    protected final Objective onesObj = new Objective("Leading Ones", Objective.Sign.MAX);
    protected final Objective zerosObj = new Objective("Trailing Zeros", Objective.Sign.MAX);
    protected final List<Objective> objectives = Arrays.asList(this.onesObj, this.zerosObj);

    @Override
    public Objectives evaluate(BinaryString phenotype) {
        int ones = 0;
        int size = phenotype.size();
        while (ones < size) {
            boolean value = (Boolean)phenotype.get(ones);
            if (!value) break;
            ++ones;
        }
        int zeros = 0;
        while (zeros < size) {
            boolean value = (Boolean)phenotype.get(size - zeros - 1);
            if (value) break;
            ++zeros;
        }
        Objectives objectives = new Objectives();
        objectives.add(this.onesObj, ones);
        objectives.add(this.zerosObj, zeros);
        return objectives;
    }

    @Override
    public Collection<Objective> getObjectives() {
        return this.objectives;
    }
}

