/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.benchmark.dtlz;

import org.opt4j.benchmark.BinaryCreator;
import org.opt4j.benchmark.BinaryToDoubleDecoder;
import org.opt4j.benchmark.Bits;
import org.opt4j.benchmark.DoubleCopyDecoder;
import org.opt4j.benchmark.DoubleCreator;
import org.opt4j.benchmark.M;
import org.opt4j.benchmark.N;
import org.opt4j.benchmark.dtlz.DTLZ1;
import org.opt4j.benchmark.dtlz.DTLZ2;
import org.opt4j.benchmark.dtlz.DTLZ3;
import org.opt4j.benchmark.dtlz.DTLZ4;
import org.opt4j.benchmark.dtlz.DTLZ5;
import org.opt4j.benchmark.dtlz.DTLZ6;
import org.opt4j.benchmark.dtlz.DTLZ7;
import org.opt4j.config.annotations.Info;
import org.opt4j.config.annotations.Order;
import org.opt4j.config.annotations.Required;
import org.opt4j.core.problem.ProblemModule;
import org.opt4j.start.Constant;

@Info(value="DTLZ Problem Suite.  (n = m + k - 1)")
public class DTLZModule
extends ProblemModule {
    @Order(value=0)
    @Info(value="The DTLZ function")
    protected Function function = Function.DTLZ1;
    @Required(property="function", elements={"DTLZ4"})
    @Order(value=1)
    @Constant(value="alpha", namespace=DTLZ4.class)
    protected double alpha = 100.0;
    @Order(value=2)
    @Info(value="The number of objectives.")
    protected int m = 3;
    @Order(value=3)
    @Info(value="The size of the search space.")
    protected int n = 7;
    @Order(value=4)
    @Info(value="The k value.")
    protected int k = 5;
    @Order(value=10)
    @Info(value="The encoding of the optimization problem.")
    protected Encoding encoding = Encoding.DOUBLE;
    @Required(property="encoding", elements={"BINARY"})
    @Info(value="The number of bits per double value.")
    protected int bits = 30;

    public int getBits() {
        return this.bits;
    }

    public void setBits(int bits) {
        this.bits = bits;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Encoding encoding) {
        this.encoding = encoding;
    }

    public Function getFunction() {
        return this.function;
    }

    public void setFunction(Function function) {
        this.function = function;
        switch (function) {
            default: {
                this.n = 7;
                this.m = 3;
                this.k = 5;
                break;
            }
            case DTLZ2: 
            case DTLZ3: 
            case DTLZ4: 
            case DTLZ5: 
            case DTLZ6: {
                this.n = 12;
                this.m = 3;
                this.k = 10;
                break;
            }
            case DTLZ7: {
                this.n = 22;
                this.m = 3;
                this.k = 20;
            }
        }
    }

    public int getN() {
        return this.n;
    }

    public void setN(int n) {
        this.n = n;
        this.k = n - this.m + 1;
    }

    public int getM() {
        return this.m;
    }

    public void setM(int m) {
        this.m = m;
        this.k = this.n - m + 1;
    }

    public int getK() {
        return this.k;
    }

    public void setK(int k) {
        this.k = k;
        this.n = this.m + k - 1;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    @Override
    public void config() {
        this.n = this.m + this.k - 1;
        Class creator = null;
        Class decoder = null;
        Class evaluator = null;
        switch (this.encoding) {
            case BINARY: {
                creator = BinaryCreator.class;
                decoder = BinaryToDoubleDecoder.class;
                break;
            }
            case DOUBLE: {
                creator = DoubleCreator.class;
                decoder = DoubleCopyDecoder.class;
            }
        }
        switch (this.function) {
            case DTLZ1: {
                evaluator = DTLZ1.class;
                break;
            }
            case DTLZ2: {
                evaluator = DTLZ2.class;
                break;
            }
            case DTLZ3: {
                evaluator = DTLZ3.class;
                break;
            }
            case DTLZ4: {
                evaluator = DTLZ4.class;
                break;
            }
            case DTLZ5: {
                evaluator = DTLZ5.class;
                break;
            }
            case DTLZ6: {
                evaluator = DTLZ6.class;
                break;
            }
            case DTLZ7: {
                evaluator = DTLZ7.class;
                break;
            }
            default: {
                evaluator = DTLZ1.class;
            }
        }
        this.bindConstant(N.class).to(this.n);
        this.bindConstant(M.class).to(this.m);
        this.bindConstant(Bits.class).to(this.bits);
        this.bindProblem(creator, decoder, evaluator);
    }

    public static enum Encoding {
        DOUBLE,
        BINARY;

    }

    public static enum Function {
        DTLZ1,
        DTLZ2,
        DTLZ3,
        DTLZ4,
        DTLZ5,
        DTLZ6,
        DTLZ7;

    }
}

