/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.benchmark.dtlz;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opt4j.benchmark.DoubleString;
import org.opt4j.core.Objective;
import org.opt4j.core.Objectives;
import org.opt4j.core.problem.Evaluator;

abstract class DTLZEvaluator
implements Evaluator<DoubleString> {
    protected final List<Objective> objectives = new ArrayList<Objective>();
    protected final int m;
    protected final int n;

    public DTLZEvaluator(int m, int n) {
        this.m = m;
        this.n = n;
        int i = 0;
        while (i < m) {
            this.objectives.add(new Objective("f" + (i + 1), Objective.Sign.MIN));
            ++i;
        }
    }

    protected abstract List<Double> f(List<Double> var1, double var2);

    protected abstract double g(List<Double> var1);

    @Override
    public Objectives evaluate(DoubleString x) {
        double g = this.g(x.subList(this.m - 1, this.n));
        List<Double> f = this.f(x.subList(0, this.m - 1), g);
        Objectives obj = new Objectives();
        int i = 0;
        while (i < this.objectives.size()) {
            Objective objective = this.objectives.get(i);
            obj.add(objective, f.get(i));
            ++i;
        }
        return obj;
    }

    @Override
    public Collection<Objective> getObjectives() {
        return this.objectives;
    }
}

