/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.benchmark.dtlz;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opt4j.benchmark.M;
import org.opt4j.benchmark.N;
import org.opt4j.benchmark.dtlz.DTLZ2;
import org.opt4j.start.Constant;

public class DTLZ4
extends DTLZ2 {
    protected final double alpha;

    @Inject
    public DTLZ4(@M int m, @N int n, @Constant(value="alpha", namespace=DTLZ4.class) double alpha) {
        super(m, n);
        this.alpha = alpha;
    }

    @Override
    protected List<Double> f(List<Double> x, double g) {
        ArrayList<Double> f = new ArrayList<Double>();
        double a = 1.0 + g;
        int i = 0;
        while (i < this.m) {
            if (i > 0) {
                a *= Math.cos(Math.PI * Math.pow(x.get(i - 1), this.alpha) / 2.0);
            }
            double value = a;
            if (i < x.size()) {
                value *= Math.sin(Math.PI * Math.pow(x.get(i), this.alpha) / 2.0);
            }
            f.add(value);
            ++i;
        }
        Collections.reverse(f);
        return f;
    }
}

