/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.benchmark;

import com.google.inject.Inject;
import java.util.List;
import org.opt4j.benchmark.BinaryString;
import org.opt4j.benchmark.Bits;
import org.opt4j.benchmark.DoubleString;
import org.opt4j.benchmark.N;
import org.opt4j.core.problem.Decoder;

public class BinaryToDoubleDecoder
implements Decoder<BinaryString, DoubleString> {
    protected final int n;
    protected final int bits;

    @Inject
    public BinaryToDoubleDecoder(@N int n, @Bits int bits) {
        this.n = n;
        this.bits = bits;
    }

    @Override
    public DoubleString decode(BinaryString genotype) {
        DoubleString phenotype = new DoubleString();
        int i = 0;
        while (i < this.n) {
            int begin = i * this.bits;
            int end = begin + this.bits;
            double x = this.toDouble(genotype, begin, end);
            phenotype.add(x);
            ++i;
        }
        return phenotype;
    }

    private double toDouble(List<Boolean> list, int begin, int end) {
        int b = 1;
        boolean sum = false;
        int i = end - 1;
        while (i >= begin) {
            if (list.get(i).booleanValue()) {
                sum |= b;
            }
            b <<= 1;
            --i;
        }
        return (double)sum / (double)b;
    }
}

