/**
 * Opt4J is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 * 
 * Opt4J is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
 * License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with Opt4J. If not, see http://www.gnu.org/licenses/. 
 */

package org.opt4j.operator.algebra;

/**
 * The {@code Add} term adds multiple {@code Terms}.
 * 
 * @author lukasiewycz
 * 
 */
public class Add implements Term {

	protected final Term[] terms;

	/**
	 * Constructs an {@code Add} term.
	 * 
	 * @param terms
	 *            the {@code Terms} to be added
	 */
	public Add(final Term... terms) {
		super();
		this.terms = terms;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.opt4j.operator.algebra.Term#calculate(double[])
	 */
	public double calculate(double... values) {
		double sum = 0.0;
		for (Term term : terms) {
			sum += term.calculate(values);
		}
		return sum;
	}

}
