/**
 * Opt4J is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 * 
 * Opt4J is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
 * License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with Opt4J. If not, see http://www.gnu.org/licenses/. 
 */

package org.opt4j.benchmark.zdt;

import static java.lang.Math.PI;
import static java.lang.Math.sin;

/**
 * Function ZDT 3.
 * 
 * @author lukasiewycz
 * 
 */
public class ZDT3 extends ZDT1 {


	/* (non-Javadoc)
	 * @see org.opt4j.benchmark.zdt.ZDT1#h(double, double)
	 */
	@Override
	protected double h(double f1, double g) {
		double h = super.h(f1, g) - (f1 / g) * sin(10 * PI * f1);
		return h;
	}

}
