/**
 * Opt4J is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 * 
 * Opt4J is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
 * License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with Opt4J. If not, see http://www.gnu.org/licenses/. 
 */

package org.opt4j.benchmark.zdt;

import static java.lang.Math.sqrt;

import java.util.ArrayList;
import java.util.List;

import org.opt4j.benchmark.DoubleString;
import org.opt4j.core.problem.Phenotype;

/**
 * Function ZDT 1.
 * 
 * @author lukasiewycz, helwig
 * 
 */
public class ZDT1 extends ZDTEvaluator<DoubleString> {

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.opt4j.benchmark.zdt.ZDTEvaluator#f1(org.opt4j.core.Phenotype)
	 */
	@Override
	protected double f1(DoubleString x) {
		return x.get(0);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.opt4j.benchmark.zdt.ZDTEvaluator#g(org.opt4j.core.Phenotype)
	 */
	@Override
	protected double g(DoubleString x) {
		double sum = 0;
		for (int i = 1; i < x.size(); i++) {
			sum += x.get(i);
		}
		double g = 1.0 + 9.0 * sum / (x.size() - 1);
		return g;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.opt4j.benchmark.zdt.ZDTEvaluator#h(double, double)
	 */
	@Override
	protected double h(double f1, double g) {
		double h = 1.0 - sqrt(f1 / g);
		return h;
	}

	protected List<Double> convert(Phenotype phenotype) {
		List<Double> list = toDoubleList(phenotype);

		List<Double> x = new ArrayList<Double>();

		for (double v : list) {
			double value = v;

			if (value < 0) {
				value = 0;
			} else if (value > 1) {
				value = 1;
			}

			x.add(value);

		}
		return x;
	}

	/**
	 * Creates a list of doubles from an arbitrary genotype ({@code
	 * DoubleVectorPhenotype} or {@code BooleanGenotype}).
	 * 
	 * @param phenotype
	 *            the phenotype
	 * @return the list of doubles
	 */
	@SuppressWarnings("unchecked")
	protected List<Double> toDoubleList(Phenotype phenotype) {
		List<Double> list;
		if (phenotype instanceof List) {
			list = (List<Double>) phenotype;
		} else {
			List<Boolean> blist = (List<Boolean>) phenotype;
			list = new ArrayList<Double>();
			for (int i = 0; i < (blist.size() / 30); i++) {
				double value = toDouble(blist, i * 30, 30);
				list.add(value);
			}
		}
		return list;
	}

	/**
	 * Converts a binary representation of a double to a double value.
	 * 
	 * @param list
	 *            the complete list of doubles
	 * @param offset
	 *            the offset to the first bit
	 * @param bits
	 *            the number of bits for one double
	 * @return the double value
	 */
	protected double toDouble(List<Boolean> list, int offset, int bits) {
		double value = 0;
		for (int i = 0; i < bits; i++) {
			if (list.get(i + offset)) {
				value += Math.pow(0.5, i + 1);
			}
		}
		return value;
	}

}
