/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.mathematics.vector;

import java.util.Iterator;
import java.util.List;
import javolution.context.ConcurrentContext;
import javolution.context.ObjectFactory;
import javolution.lang.MathLib;
import javolution.util.FastTable;
import org.jscience.mathematics.number.Float64;
import org.jscience.mathematics.vector.DenseMatrix;
import org.jscience.mathematics.vector.DimensionException;
import org.jscience.mathematics.vector.Float64Vector;
import org.jscience.mathematics.vector.LUDecomposition;
import org.jscience.mathematics.vector.Matrix;
import org.jscience.mathematics.vector.Vector;

public final class Float64Matrix
extends Matrix<Float64> {
    int _n;
    boolean _transposed;
    final FastTable<Float64Vector> _rows = new FastTable();
    private static ObjectFactory<Float64Matrix> FACTORY = new ObjectFactory<Float64Matrix>(){

        protected Float64Matrix create() {
            return new Float64Matrix(null);
        }

        protected void cleanup(Float64Matrix matrix) {
            matrix._rows.reset();
        }
    };
    private static final long serialVersionUID = 1L;

    public static Float64Matrix valueOf(double[][] values) {
        int m = values.length;
        int n = values[0].length;
        Float64Matrix M = Float64Matrix.newInstance(n, false);
        int i = 0;
        while (i < m) {
            Float64Vector row = Float64Vector.valueOf(values[i]);
            if (row.getDimension() != n) {
                throw new DimensionException();
            }
            M._rows.add((Object)row);
            ++i;
        }
        return M;
    }

    public static Float64Matrix valueOf(Float64Vector ... rows) {
        int n = rows[0].getDimension();
        Float64Matrix M = Float64Matrix.newInstance(n, false);
        int i = 0;
        int m = rows.length;
        while (i < m) {
            Float64Vector rowi = rows[i];
            if (rowi.getDimension() != n) {
                throw new DimensionException("All vectors must have the same dimension.");
            }
            M._rows.add((Object)rowi);
            ++i;
        }
        return M;
    }

    public static Float64Matrix valueOf(List<Float64Vector> rows) {
        int n = rows.get(0).getDimension();
        Float64Matrix M = Float64Matrix.newInstance(n, false);
        Iterator<Float64Vector> iterator = rows.iterator();
        int i = 0;
        int m = rows.size();
        while (i < m) {
            Float64Vector rowi = iterator.next();
            if (rowi.getDimension() != n) {
                throw new DimensionException("All vectors must have the same dimension.");
            }
            M._rows.add((Object)rowi);
            ++i;
        }
        return M;
    }

    public static Float64Matrix valueOf(Matrix<Float64> that) {
        if (that instanceof Float64Matrix) {
            return (Float64Matrix)that;
        }
        int n = that.getNumberOfColumns();
        int m = that.getNumberOfRows();
        Float64Matrix M = Float64Matrix.newInstance(n, false);
        int i = 0;
        while (i < m) {
            Float64Vector rowi = Float64Vector.valueOf(that.getRow(i));
            M._rows.add((Object)rowi);
            ++i;
        }
        return M;
    }

    @Override
    public int getNumberOfRows() {
        return this._transposed ? this._n : this._rows.size();
    }

    @Override
    public int getNumberOfColumns() {
        return this._transposed ? this._rows.size() : this._n;
    }

    @Override
    public Float64 get(int i, int j) {
        return this._transposed ? ((Float64Vector)this._rows.get(j)).get(i) : ((Float64Vector)this._rows.get(i)).get(j);
    }

    public Float64Vector getRow(int i) {
        if (!this._transposed) {
            return (Float64Vector)this._rows.get(i);
        }
        int n = this._rows.size();
        int m = this._n;
        if (i < 0 || i >= m) {
            throw new DimensionException();
        }
        Float64Vector V = Float64Vector.newInstance(n);
        int j = 0;
        while (j < n) {
            V.set(j, ((Float64Vector)this._rows.get(j)).get(i).doubleValue());
            ++j;
        }
        return V;
    }

    public Float64Vector getColumn(int j) {
        if (this._transposed) {
            return (Float64Vector)this._rows.get(j);
        }
        int m = this._rows.size();
        if (j < 0 || j >= this._n) {
            throw new DimensionException();
        }
        Float64Vector V = Float64Vector.newInstance(m);
        int i = 0;
        while (i < m) {
            V.set(i, ((Float64Vector)this._rows.get(i)).get(j).doubleValue());
            ++i;
        }
        return V;
    }

    public Float64Vector getDiagonal() {
        int m = this.getNumberOfRows();
        int n = this.getNumberOfColumns();
        int dimension = MathLib.min((int)m, (int)n);
        Float64Vector V = Float64Vector.newInstance(dimension);
        int i = 0;
        while (i < dimension) {
            V.set(i, this.get(i, i).doubleValue());
            ++i;
        }
        return V;
    }

    @Override
    public Float64Matrix opposite() {
        Float64Matrix M = Float64Matrix.newInstance(this._n, this._transposed);
        int i = 0;
        int p = this._rows.size();
        while (i < p) {
            M._rows.add((Object)((Float64Vector)this._rows.get(i)).opposite());
            ++i;
        }
        return M;
    }

    @Override
    public Float64Matrix plus(Matrix<Float64> that) {
        if (this.getNumberOfRows() != that.getNumberOfRows()) {
            throw new DimensionException();
        }
        Float64Matrix M = Float64Matrix.newInstance(this._n, this._transposed);
        int i = 0;
        int p = this._rows.size();
        while (i < p) {
            M._rows.add((Object)((Float64Vector)this._rows.get(i)).plus((Vector)(this._transposed ? that.getColumn(i) : that.getRow(i))));
            ++i;
        }
        return M;
    }

    public Float64Matrix minus(Matrix<Float64> that) {
        return this.plus((Matrix)that.opposite());
    }

    @Override
    public Float64Matrix times(Float64 k) {
        Float64Matrix M = Float64Matrix.newInstance(this._n, this._transposed);
        int i = 0;
        int p = this._rows.size();
        while (i < p) {
            M._rows.add((Object)((Float64Vector)this._rows.get(i)).times(k));
            ++i;
        }
        return M;
    }

    @Override
    public Float64Vector times(Vector<Float64> v) {
        if (v.getDimension() != this.getNumberOfColumns()) {
            throw new DimensionException();
        }
        int m = this.getNumberOfRows();
        Float64Vector V = Float64Vector.newInstance(m);
        int i = 0;
        while (i < m) {
            V.set(i, ((Float64)this.getRow(i).times((Vector)v)).doubleValue());
            ++i;
        }
        return V;
    }

    @Override
    public Float64Matrix times(Matrix<Float64> that) {
        int n = this.getNumberOfColumns();
        int m = this.getNumberOfRows();
        int p = that.getNumberOfColumns();
        if (that.getNumberOfRows() != n) {
            throw new DimensionException();
        }
        Float64Matrix M = Float64Matrix.newInstance(m, true);
        M._rows.setSize(p);
        Multiply multiply = Multiply.valueOf(this, that, 0, p, M._rows);
        multiply.run();
        Multiply.recycle(multiply);
        return M;
    }

    private FastTable<Float64Vector> getRows() {
        if (!this._transposed) {
            return this._rows;
        }
        FastTable rows = FastTable.newInstance();
        int i = 0;
        while (i < this._n) {
            rows.add((Object)this.getRow(i));
            ++i;
        }
        return rows;
    }

    public Float64Matrix inverse() {
        if (!this.isSquare()) {
            throw new DimensionException("Matrix not square");
        }
        return Float64Matrix.valueOf(LUDecomposition.valueOf(this).inverse());
    }

    @Override
    public Float64 determinant() {
        return LUDecomposition.valueOf(this).determinant();
    }

    public Float64Matrix transpose() {
        Float64Matrix M = Float64Matrix.newInstance(this._n, !this._transposed);
        M._rows.addAll(this._rows);
        return M;
    }

    @Override
    public Float64 cofactor(int i, int j) {
        if (this._transposed) {
            int k = i;
            i = j;
            j = k;
        }
        int m = this._rows.size();
        Float64Matrix M = Float64Matrix.newInstance(m - 1, this._transposed);
        int k1 = 0;
        while (k1 < m) {
            if (k1 != i) {
                Float64Vector row = (Float64Vector)this._rows.get(k1);
                Float64Vector V = Float64Vector.newInstance(this._n - 1);
                M._rows.add((Object)V);
                int k2 = 0;
                int k = 0;
                while (k2 < this._n) {
                    if (k2 != j) {
                        V.set(k++, row.get(k2).doubleValue());
                    }
                    ++k2;
                }
            }
            ++k1;
        }
        return M.determinant();
    }

    public Float64Matrix adjoint() {
        Float64Matrix M = Float64Matrix.newInstance(this._n, this._transposed);
        int m = this._rows.size();
        int i = 0;
        while (i < m) {
            Float64Vector row = Float64Vector.newInstance(this._n);
            M._rows.add((Object)row);
            int j = 0;
            while (j < this._n) {
                Float64 cofactor = this._transposed ? this.cofactor(j, i) : this.cofactor(i, j);
                row.set(j, (i + j) % 2 == 0 ? cofactor.doubleValue() : cofactor.opposite().doubleValue());
                ++j;
            }
            ++i;
        }
        return M.transpose();
    }

    public Float64Matrix tensor(Matrix<Float64> that) {
        return Float64Matrix.valueOf(DenseMatrix.valueOf(this).tensor(that));
    }

    public Float64Vector vectorization() {
        return Float64Vector.valueOf(DenseMatrix.valueOf(this).vectorization());
    }

    @Override
    public Float64Matrix copy() {
        Float64Matrix M = Float64Matrix.newInstance(this._n, this._transposed);
        for (Float64Vector row : this._rows) {
            M._rows.add((Object)row.copy());
        }
        return M;
    }

    static Float64Matrix newInstance(int n, boolean transposed) {
        Float64Matrix M = (Float64Matrix)FACTORY.object();
        M._n = n;
        M._transposed = transposed;
        return M;
    }

    private Float64Matrix() {
    }

    /* synthetic */ Float64Matrix(Float64Matrix float64Matrix) {
        this();
    }

    private static class Multiply
    implements Runnable {
        private static final ObjectFactory<Multiply> FACTORY = new ObjectFactory<Multiply>(){

            protected Multiply create() {
                return new Multiply();
            }
        };
        private Float64Matrix _left;
        private Matrix<Float64> _right;
        private int _rightColumnStart;
        private int _rightColumnEnd;
        private FastTable<Float64Vector> _columnsResult;

        private Multiply() {
        }

        static Multiply valueOf(Float64Matrix left, Matrix<Float64> right, int rightColumnStart, int rightColumnEnd, FastTable<Float64Vector> columnsResult) {
            Multiply multiply = (Multiply)FACTORY.object();
            multiply._left = left;
            multiply._right = right;
            multiply._rightColumnStart = rightColumnStart;
            multiply._rightColumnEnd = rightColumnEnd;
            multiply._columnsResult = columnsResult;
            return multiply;
        }

        static void recycle(Multiply multiply) {
            multiply._left = null;
            multiply._right = null;
            multiply._columnsResult = null;
            FACTORY.recycle((Object)multiply);
        }

        @Override
        public void run() {
            if (this._rightColumnEnd - this._rightColumnStart < 32) {
                FastTable rows = this._left.getRows();
                int m = rows.size();
                int j = this._rightColumnStart;
                while (j < this._rightColumnEnd) {
                    Vector<Float64> thatColj = this._right.getColumn(j);
                    Float64Vector column = Float64Vector.newInstance(m);
                    this._columnsResult.set(j, (Object)column);
                    int i = 0;
                    while (i < m) {
                        column.set(i, ((Float64)((Float64Vector)rows.get(i)).times((Vector)thatColj)).doubleValue());
                        ++i;
                    }
                    ++j;
                }
            } else {
                int halfIndex = this._rightColumnStart + this._rightColumnEnd >> 1;
                Multiply firstHalf = Multiply.valueOf(this._left, this._right, this._rightColumnStart, halfIndex, this._columnsResult);
                Multiply secondHalf = Multiply.valueOf(this._left, this._right, halfIndex, this._rightColumnEnd, this._columnsResult);
                ConcurrentContext.enter();
                try {
                    ConcurrentContext.execute((Runnable)firstHalf);
                    ConcurrentContext.execute((Runnable)secondHalf);
                }
                finally {
                    ConcurrentContext.exit();
                }
                Multiply.recycle(firstHalf);
                Multiply.recycle(secondHalf);
            }
        }
    }
}

