/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.mathematics.vector;

import java.util.Iterator;
import java.util.List;
import javolution.context.ConcurrentContext;
import javolution.context.ObjectFactory;
import javolution.lang.MathLib;
import javolution.util.FastTable;
import org.jscience.mathematics.structure.Field;
import org.jscience.mathematics.vector.DenseVector;
import org.jscience.mathematics.vector.DimensionException;
import org.jscience.mathematics.vector.LUDecomposition;
import org.jscience.mathematics.vector.Matrix;
import org.jscience.mathematics.vector.Vector;

public final class DenseMatrix<F extends Field<F>>
extends Matrix<F> {
    int _n;
    boolean _transposed;
    final FastTable<DenseVector<F>> _rows = new FastTable();
    private static ObjectFactory<DenseMatrix> FACTORY = new ObjectFactory<DenseMatrix>(){

        protected DenseMatrix create() {
            return new DenseMatrix(null);
        }

        protected void cleanup(DenseMatrix matrix) {
            matrix._rows.reset();
        }
    };
    private static final long serialVersionUID = 1L;

    public static <F extends Field<F>> DenseMatrix<F> valueOf(F[][] elements) {
        int m = elements.length;
        int n = elements[0].length;
        DenseMatrix<F> M = DenseMatrix.newInstance(n, false);
        int i = 0;
        while (i < m) {
            DenseVector row = DenseVector.valueOf(elements[i]);
            if (row.getDimension() != n) {
                throw new DimensionException();
            }
            M._rows.add((Object)row);
            ++i;
        }
        return M;
    }

    public static <F extends Field<F>> DenseMatrix<F> valueOf(DenseVector<F> ... rows) {
        int n = rows[0].getDimension();
        DenseMatrix<F> M = DenseMatrix.newInstance(n, false);
        int i = 0;
        int m = rows.length;
        while (i < m) {
            DenseVector<F> rowi = rows[i];
            if (rowi.getDimension() != n) {
                throw new DimensionException("All vectors must have the same dimension.");
            }
            M._rows.add(rowi);
            ++i;
        }
        return M;
    }

    public static <F extends Field<F>> DenseMatrix<F> valueOf(List<DenseVector<F>> rows) {
        int n = rows.get(0).getDimension();
        DenseMatrix<F> M = DenseMatrix.newInstance(n, false);
        Iterator<DenseVector<F>> iterator = rows.iterator();
        int i = 0;
        int m = rows.size();
        while (i < m) {
            DenseVector<F> rowi = iterator.next();
            if (rowi.getDimension() != n) {
                throw new DimensionException("All vectors must have the same dimension.");
            }
            M._rows.add(rowi);
            ++i;
        }
        return M;
    }

    public static <F extends Field<F>> DenseMatrix<F> valueOf(Matrix<F> that) {
        if (that instanceof DenseMatrix) {
            return (DenseMatrix)that;
        }
        int n = that.getNumberOfColumns();
        int m = that.getNumberOfRows();
        DenseMatrix<F> M = DenseMatrix.newInstance(n, false);
        int i = 0;
        while (i < m) {
            DenseVector<F> rowi = DenseVector.valueOf(that.getRow(i));
            M._rows.add(rowi);
            ++i;
        }
        return M;
    }

    @Override
    public int getNumberOfRows() {
        return this._transposed ? this._n : this._rows.size();
    }

    @Override
    public int getNumberOfColumns() {
        return this._transposed ? this._rows.size() : this._n;
    }

    @Override
    public F get(int i, int j) {
        return this._transposed ? ((DenseVector)this._rows.get(j)).get(i) : ((DenseVector)this._rows.get(i)).get(j);
    }

    @Override
    public DenseVector<F> getRow(int i) {
        if (!this._transposed) {
            return (DenseVector)this._rows.get(i);
        }
        int n = this._rows.size();
        int m = this._n;
        if (i < 0 || i >= m) {
            throw new DimensionException();
        }
        DenseVector V = DenseVector.newInstance();
        int j = 0;
        while (j < n) {
            V._elements.add(((DenseVector)this._rows.get(j)).get(i));
            ++j;
        }
        return V;
    }

    @Override
    public DenseVector<F> getColumn(int j) {
        if (this._transposed) {
            return (DenseVector)this._rows.get(j);
        }
        int m = this._rows.size();
        if (j < 0 || j >= this._n) {
            throw new DimensionException();
        }
        DenseVector V = DenseVector.newInstance();
        int i = 0;
        while (i < m) {
            V._elements.add(((DenseVector)this._rows.get(i)).get(j));
            ++i;
        }
        return V;
    }

    @Override
    public DenseVector<F> getDiagonal() {
        int m = this.getNumberOfRows();
        int n = this.getNumberOfColumns();
        int dimension = MathLib.min((int)m, (int)n);
        DenseVector V = DenseVector.newInstance();
        int i = 0;
        while (i < dimension) {
            V._elements.add(this.get(i, i));
            ++i;
        }
        return V;
    }

    @Override
    public DenseMatrix<F> opposite() {
        DenseMatrix<F> M = DenseMatrix.newInstance(this._n, this._transposed);
        int i = 0;
        int p = this._rows.size();
        while (i < p) {
            M._rows.add((Object)((DenseVector)this._rows.get(i)).opposite());
            ++i;
        }
        return M;
    }

    @Override
    public DenseMatrix<F> plus(Matrix<F> that) {
        if (this.getNumberOfRows() != that.getNumberOfRows()) {
            throw new DimensionException();
        }
        DenseMatrix<F> M = DenseMatrix.newInstance(this._n, this._transposed);
        int i = 0;
        int p = this._rows.size();
        while (i < p) {
            M._rows.add((Object)((DenseVector)this._rows.get(i)).plus((Vector)(this._transposed ? that.getColumn(i) : that.getRow(i))));
            ++i;
        }
        return M;
    }

    @Override
    public DenseMatrix<F> minus(Matrix<F> that) {
        return this.plus((Matrix)that.opposite());
    }

    @Override
    public DenseMatrix<F> times(F k) {
        DenseMatrix<F> M = DenseMatrix.newInstance(this._n, this._transposed);
        int i = 0;
        int p = this._rows.size();
        while (i < p) {
            M._rows.add((Object)((DenseVector)this._rows.get(i)).times((Field)k));
            ++i;
        }
        return M;
    }

    @Override
    public DenseVector<F> times(Vector<F> v) {
        if (v.getDimension() != this.getNumberOfColumns()) {
            throw new DimensionException();
        }
        int m = this.getNumberOfRows();
        DenseVector V = DenseVector.newInstance();
        int i = 0;
        while (i < m) {
            V._elements.add(((DenseVector)this.getRow(i)).times(v));
            ++i;
        }
        return V;
    }

    @Override
    public DenseMatrix<F> times(Matrix<F> that) {
        int n = this.getNumberOfColumns();
        int m = this.getNumberOfRows();
        int p = that.getNumberOfColumns();
        if (that.getNumberOfRows() != n) {
            throw new DimensionException();
        }
        DenseMatrix<F> M = DenseMatrix.newInstance(m, true);
        M._rows.setSize(p);
        Multiply<F> multiply = Multiply.valueOf(this, that, 0, p, M._rows);
        multiply.run();
        Multiply.recycle(multiply);
        return M;
    }

    private FastTable<DenseVector<F>> getRows() {
        if (!this._transposed) {
            return this._rows;
        }
        FastTable rows = FastTable.newInstance();
        int i = 0;
        while (i < this._n) {
            rows.add((Object)this.getRow(i));
            ++i;
        }
        return rows;
    }

    @Override
    public DenseMatrix<F> inverse() {
        if (!this.isSquare()) {
            throw new DimensionException("Matrix not square");
        }
        return LUDecomposition.valueOf(this).inverse();
    }

    @Override
    public F determinant() {
        return LUDecomposition.valueOf(this).determinant();
    }

    @Override
    public DenseMatrix<F> transpose() {
        DenseMatrix<F> M = DenseMatrix.newInstance(this._n, !this._transposed);
        M._rows.addAll(this._rows);
        return M;
    }

    @Override
    public F cofactor(int i, int j) {
        if (this._transposed) {
            int k = i;
            i = j;
            j = k;
        }
        int m = this._rows.size();
        DenseMatrix<F> M = DenseMatrix.newInstance(m - 1, this._transposed);
        int k1 = 0;
        while (k1 < m) {
            if (k1 != i) {
                DenseVector row = (DenseVector)this._rows.get(k1);
                DenseVector V = DenseVector.newInstance();
                M._rows.add(V);
                int k2 = 0;
                while (k2 < this._n) {
                    if (k2 != j) {
                        V._elements.add(row.get(k2));
                    }
                    ++k2;
                }
            }
            ++k1;
        }
        return M.determinant();
    }

    @Override
    public DenseMatrix<F> adjoint() {
        DenseMatrix<F> M = DenseMatrix.newInstance(this._n, this._transposed);
        int m = this._rows.size();
        int i = 0;
        while (i < m) {
            DenseVector row = DenseVector.newInstance();
            M._rows.add(row);
            int j = 0;
            while (j < this._n) {
                F cofactor = this._transposed ? this.cofactor(j, i) : this.cofactor(i, j);
                row._elements.add((i + j) % 2 == 0 ? cofactor : (Field)cofactor.opposite());
                ++j;
            }
            ++i;
        }
        return M.transpose();
    }

    @Override
    public Matrix<F> tensor(Matrix<F> that) {
        int thism = this.getNumberOfRows();
        int thisn = this.getNumberOfColumns();
        int thatm = that.getNumberOfRows();
        int thatn = that.getNumberOfColumns();
        int n = thisn * thatn;
        int m = thism * thatm;
        DenseMatrix<F> M = DenseMatrix.newInstance(n, false);
        int i = 0;
        while (i < m) {
            int i_rem_thatm = i % thatm;
            int i_div_thatm = i / thatm;
            DenseVector row = DenseVector.newInstance();
            M._rows.add(row);
            int j = 0;
            while (j < thisn) {
                F a = this.get(i_div_thatm, j);
                int k = 0;
                while (k < thatn) {
                    row._elements.add((Object)((Field)a.times(that.get(i_rem_thatm, k))));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return M;
    }

    @Override
    public Vector<F> vectorization() {
        DenseVector V = DenseVector.newInstance();
        int j = 0;
        int n = this.getNumberOfColumns();
        while (j < n) {
            Vector column = this.getColumn(j);
            int i = 0;
            int m = column.getDimension();
            while (i < m) {
                V._elements.add(column.get(i));
                ++i;
            }
            ++j;
        }
        return V;
    }

    @Override
    public DenseMatrix<F> copy() {
        DenseMatrix<F> M = DenseMatrix.newInstance(this._n, this._transposed);
        for (DenseVector row : this._rows) {
            M._rows.add(row.copy());
        }
        return M;
    }

    void set(int i, int j, F e) {
        if (this._transposed) {
            ((DenseVector)this._rows.get((int)j))._elements.set(i, e);
        } else {
            ((DenseVector)this._rows.get((int)i))._elements.set(j, e);
        }
    }

    static <F extends Field<F>> DenseMatrix<F> newInstance(int n, boolean transposed) {
        DenseMatrix M = (DenseMatrix)FACTORY.object();
        M._n = n;
        M._transposed = transposed;
        return M;
    }

    private DenseMatrix() {
    }

    /* synthetic */ DenseMatrix(DenseMatrix denseMatrix) {
        this();
    }

    private static class Multiply<F extends Field<F>>
    implements Runnable {
        private static final ObjectFactory<Multiply> FACTORY = new ObjectFactory<Multiply>(){

            protected Multiply create() {
                return new Multiply();
            }
        };
        private DenseMatrix<F> _left;
        private Matrix<F> _right;
        private int _rightColumnStart;
        private int _rightColumnEnd;
        private FastTable<DenseVector<F>> _columnsResult;

        private Multiply() {
        }

        static <F extends Field<F>> Multiply<F> valueOf(DenseMatrix<F> left, Matrix<F> right, int rightColumnStart, int rightColumnEnd, FastTable<DenseVector<F>> columnsResult) {
            Multiply multiply = (Multiply)FACTORY.object();
            multiply._left = left;
            multiply._right = right;
            multiply._rightColumnStart = rightColumnStart;
            multiply._rightColumnEnd = rightColumnEnd;
            multiply._columnsResult = columnsResult;
            return multiply;
        }

        static <F extends Field<F>> void recycle(Multiply<F> multiply) {
            multiply._left = null;
            multiply._right = null;
            multiply._columnsResult = null;
            FACTORY.recycle(multiply);
        }

        @Override
        public void run() {
            if (this._rightColumnEnd - this._rightColumnStart < 32) {
                FastTable rows = ((DenseMatrix)this._left).getRows();
                int m = rows.size();
                int j = this._rightColumnStart;
                while (j < this._rightColumnEnd) {
                    Vector<F> thatColj = this._right.getColumn(j);
                    DenseVector column = DenseVector.newInstance();
                    this._columnsResult.set(j, column);
                    int i = 0;
                    while (i < m) {
                        column._elements.add(((DenseVector)rows.get(i)).times(thatColj));
                        ++i;
                    }
                    ++j;
                }
            } else {
                int halfIndex = this._rightColumnStart + this._rightColumnEnd >> 1;
                Multiply<F> firstHalf = Multiply.valueOf(this._left, this._right, this._rightColumnStart, halfIndex, this._columnsResult);
                Multiply<F> secondHalf = Multiply.valueOf(this._left, this._right, halfIndex, this._rightColumnEnd, this._columnsResult);
                ConcurrentContext.enter();
                try {
                    ConcurrentContext.execute(firstHalf);
                    ConcurrentContext.execute(secondHalf);
                }
                finally {
                    ConcurrentContext.exit();
                }
                Multiply.recycle(firstHalf);
                Multiply.recycle(secondHalf);
            }
        }
    }
}

