/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.mathematics.number;

import javolution.context.HeapContext;
import javolution.context.LocalContext;
import javolution.context.ObjectFactory;
import javolution.lang.MathLib;
import javolution.text.Text;
import javolution.text.TypeFormat;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.jscience.mathematics.number.LargeInteger;
import org.jscience.mathematics.number.Number;
import org.jscience.mathematics.structure.Field;

public final class Real
extends Number<Real>
implements Field<Real> {
    static final XMLFormat<Real> XML = new XMLFormat<Real>(Real.class){

        public Real newInstance(Class<Real> cls, XMLFormat.InputElement xml) throws XMLStreamException {
            return Real.valueOf((CharSequence)xml.getAttribute("value"));
        }

        public void write(Real real, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("value", (CharSequence)real.toText());
        }

        public void read(XMLFormat.InputElement xml, Real real) {
        }
    };
    public static final Real NaN = new Real();
    public static final Real ZERO;
    public static final Real ONE;
    private static final LocalContext.Reference<Integer> EXACT_PRECISION;
    private LargeInteger _significand;
    private LargeInteger _error;
    private int _exponent;
    private static final double DIGITS_TO_BITS = 3.3219280948873626;
    private static final ObjectFactory<Real> FACTORY;
    private static final LargeInteger FIVE;
    private static final LargeInteger MINUS_FIVE;
    private static final long serialVersionUID = 1L;

    static {
        Real.NaN._significand = LargeInteger.ZERO;
        Real.NaN._error = LargeInteger.ONE;
        Real.NaN._exponent = Integer.MAX_VALUE;
        EXACT_PRECISION = new LocalContext.Reference((Object)new Integer(19));
        FACTORY = new ObjectFactory<Real>(){

            protected Real create() {
                return new Real(null);
            }
        };
        HeapContext.enter();
        try {
            ZERO = Real.valueOf(0L);
            ONE = Real.valueOf(1L);
            FIVE = LargeInteger.valueOf(5L);
            MINUS_FIVE = LargeInteger.valueOf(-5L);
        }
        finally {
            HeapContext.exit();
        }
    }

    private Real() {
    }

    public static int getExactPrecision() {
        return (Integer)EXACT_PRECISION.get();
    }

    public static void setExactPrecision(int precision) {
        EXACT_PRECISION.set((Object)precision);
    }

    public static Real valueOf(LargeInteger significand, int error, int exponent) {
        if (error < 0) {
            throw new IllegalArgumentException("Error cannot be negative");
        }
        Real real = (Real)FACTORY.object();
        real._significand = significand;
        real._error = LargeInteger.valueOf(error);
        real._exponent = exponent;
        return real;
    }

    public static Real valueOf(double doubleValue) {
        if (doubleValue == 0.0) {
            return ZERO;
        }
        if (Double.isNaN(doubleValue) || Double.isInfinite(doubleValue)) {
            return NaN;
        }
        int e = MathLib.floorLog10((double)doubleValue) - 18 + 1;
        long significand = MathLib.toLongPow10((double)doubleValue, (int)(-e));
        int error = (int)MathLib.toLongPow10((double)Math.ulp(doubleValue), (int)(-e)) + 1;
        return Real.valueOf(LargeInteger.valueOf(significand), error, e);
    }

    public static Real valueOf(long longValue) {
        return Real.valueOf(LargeInteger.valueOf(longValue), 0, 0);
    }

    public static Real valueOf(CharSequence chars) throws NumberFormatException {
        Text txt = Text.valueOf((Object)chars);
        if (txt.length() == 3 && txt.indexOf((CharSequence)"NaN", 0) == 0) {
            return NaN;
        }
        if (txt.equals((Object)"0")) {
            return ZERO;
        }
        int exponentIndex = txt.indexOf((CharSequence)"E", 0);
        if (exponentIndex >= 0) {
            int exponent = TypeFormat.parseInt((CharSequence)txt.subtext(exponentIndex + 1, txt.length()));
            Real r = Real.valueOf((CharSequence)txt.subtext(0, exponentIndex));
            if (r == ZERO) {
                return Real.valueOf(LargeInteger.ZERO, 1, exponent);
            }
            r._exponent += exponent;
            return r;
        }
        Real real = (Real)FACTORY.object();
        int errorIndex = txt.indexOf((CharSequence)"\u00b1", 0);
        if (errorIndex >= 0) {
            real._significand = LargeInteger.valueOf((CharSequence)txt.subtext(0, errorIndex));
            real._error = LargeInteger.valueOf((CharSequence)txt.subtext(errorIndex + 1, txt.length()));
            if (real._error.isNegative()) {
                throw new NumberFormatException(chars + " not parsable (error cannot be negative)");
            }
            real._exponent = 0;
            return real;
        }
        int decimalPointIndex = txt.indexOf((CharSequence)".", 0);
        if (decimalPointIndex >= 0) {
            LargeInteger integer = LargeInteger.valueOf((CharSequence)txt.subtext(0, decimalPointIndex));
            LargeInteger fraction = LargeInteger.valueOf((CharSequence)txt.subtext(decimalPointIndex + 1, txt.length()));
            int fractionDigits = chars.length() - decimalPointIndex - 1;
            real._significand = integer.isNegative() ? integer.times10pow(fractionDigits).minus(fraction) : integer.times10pow(fractionDigits).plus(fraction);
            real._error = LargeInteger.ZERO;
            real._exponent = -fractionDigits;
            return real;
        }
        real._significand = LargeInteger.valueOf(chars);
        real._error = LargeInteger.ZERO;
        real._exponent = 0;
        return real;
    }

    public LargeInteger getSignificand() {
        return this._significand;
    }

    public int getError() {
        return this._error.intValue();
    }

    public int getExponent() {
        return this._exponent;
    }

    public boolean isExact() {
        return this._error.isZero();
    }

    public int getAccuracy() {
        if (this._error.isZero()) {
            return Integer.MAX_VALUE;
        }
        if (this == NaN) {
            return Integer.MIN_VALUE;
        }
        return -this._exponent - this._error.digitLength();
    }

    public final int getPrecision() {
        if (this._error.isZero()) {
            return Integer.MAX_VALUE;
        }
        if (this == NaN) {
            return Integer.MIN_VALUE;
        }
        return this._significand.digitLength() - this._error.digitLength();
    }

    public boolean isPositive() {
        return this._significand.isPositive();
    }

    public boolean isNegative() {
        return this._significand.isNegative();
    }

    public boolean isNaN() {
        return this == NaN;
    }

    public boolean approximates(Real that) {
        Real diff = this.minus(that);
        if (diff == NaN) {
            return false;
        }
        return diff._error.isLargerThan(diff._significand);
    }

    public LargeInteger round() {
        if (this == NaN) {
            throw new ArithmeticException("Cannot convert NaN to integer value");
        }
        LargeInteger half = LargeInteger.FIVE.times10pow(this._exponent - 1);
        return this.isNegative() ? this._significand.minus(half).times10pow(this._exponent) : this._significand.plus(half).times10pow(this._exponent);
    }

    @Override
    public Real opposite() {
        if (this == NaN) {
            return NaN;
        }
        Real real = (Real)FACTORY.object();
        real._significand = this._significand.opposite();
        real._exponent = this._exponent;
        real._error = this._error;
        return real;
    }

    @Override
    public Real plus(Real that) {
        if (this == NaN || that == NaN) {
            return NaN;
        }
        if (this._exponent > that._exponent) {
            return that.plus(this);
        }
        int scale = that._exponent - this._exponent;
        Real real = (Real)FACTORY.object();
        real._exponent = this._exponent;
        real._significand = this._significand.plus(that._significand.times10pow(scale));
        real._error = this._error.plus(that._error.times10pow(scale));
        return real.normalize();
    }

    @Override
    public Real minus(Real that) {
        return this.plus(that.opposite());
    }

    @Override
    public Real times(long multiplier) {
        if (this == NaN) {
            return NaN;
        }
        Real real = (Real)FACTORY.object();
        real._exponent = this._exponent;
        real._significand = this._significand.times(multiplier);
        real._error = this._error.times(multiplier);
        return real.normalize();
    }

    @Override
    public Real times(Real that) {
        LargeInteger max;
        LargeInteger min;
        if (this == NaN || that == NaN) {
            return NaN;
        }
        long exp = (long)this._exponent + (long)that._exponent;
        if (exp > Integer.MAX_VALUE || exp < Integer.MIN_VALUE) {
            return NaN;
        }
        LargeInteger thisMin = this._significand.minus(this._error);
        LargeInteger thisMax = this._significand.plus(this._error);
        LargeInteger thatMin = that._significand.minus(that._error);
        LargeInteger thatMax = that._significand.plus(that._error);
        if (thisMin.compareTo(thisMax.opposite()) > 0) {
            if (thatMin.compareTo(thatMax.opposite()) > 0) {
                min = thisMin.times(thatMin);
                max = thisMax.times(thatMax);
            } else {
                min = thisMax.times(thatMin);
                max = thisMin.times(thatMax);
            }
        } else if (thatMin.compareTo(thatMax.opposite()) > 0) {
            min = thisMin.times(thatMax);
            max = thisMax.times(thatMin);
        } else {
            min = thisMax.times(thatMax);
            max = thisMin.times(thatMin);
        }
        Real real = (Real)FACTORY.object();
        real._exponent = (int)exp;
        real._significand = min.plus(max).shiftRight(1);
        real._error = max.minus(min);
        return real.normalize();
    }

    public Real divide(long divisor) {
        return this.divide(Real.valueOf(divisor));
    }

    public Real divide(Real that) {
        return this.times(that.inverse());
    }

    @Override
    public Real inverse() {
        if (this == NaN || this == ZERO) {
            return NaN;
        }
        if (this.isExact()) {
            return this.toInexact().inverse();
        }
        LargeInteger thisMin = this._significand.minus(this._error);
        LargeInteger thisMax = this._significand.plus(this._error);
        if (thisMin.isNegative() && thisMax.isPositive()) {
            return NaN;
        }
        int digits = MathLib.max((int)thisMin.digitLength(), (int)thisMax.digitLength());
        long exp = (long)(-this._exponent) - (long)digits - (long)digits;
        if (exp > Integer.MAX_VALUE || exp < Integer.MIN_VALUE) {
            return NaN;
        }
        LargeInteger min = Real.div(2 * digits, thisMax);
        LargeInteger max = Real.div(2 * digits, thisMin);
        Real real = (Real)FACTORY.object();
        real._exponent = (int)exp;
        real._significand = min.plus(max).shiftRight(1);
        real._error = max.minus(min).plus(LargeInteger.ONE);
        return real.normalize();
    }

    private static LargeInteger div(int exp, LargeInteger significand) {
        int expBitLength = (int)((double)exp * 3.3219280948873626);
        int precision = expBitLength - significand.bitLength() + 1;
        LargeInteger reciprocal = significand.inverseScaled(precision);
        LargeInteger result = reciprocal.times10pow(exp);
        return result.shiftRight(expBitLength + 1);
    }

    private Real toInexact() {
        int digits = this._significand.digitLength();
        int scale = Real.getExactPrecision() - digits + 1;
        Real z = (Real)FACTORY.object();
        z._significand = this._significand.times10pow(scale);
        z._error = LargeInteger.ONE;
        z._exponent = this._exponent - scale;
        return z;
    }

    public Real abs() {
        return this._significand.isNegative() ? this.opposite() : this;
    }

    @Override
    public boolean isLargerThan(Real that) {
        return this.abs().compareTo(that.abs()) > 0;
    }

    public Real sqrt() {
        if (this == NaN) {
            return NaN;
        }
        if (this.isExact()) {
            return this.toInexact().sqrt();
        }
        LargeInteger thisMin = this._significand.minus(this._error);
        LargeInteger thisMax = this._significand.plus(this._error);
        if (thisMin.isNegative()) {
            return NaN;
        }
        int exponent = this._exponent >> 1;
        if ((this._exponent & 1) == 1) {
            thisMin = thisMin.times10pow(1);
            thisMax = thisMax.times10pow(1);
        }
        LargeInteger minSqrt = thisMin.sqrt();
        LargeInteger maxSqrt = thisMax.sqrt().plus(LargeInteger.ONE);
        LargeInteger sqrt = minSqrt.plus(maxSqrt).shiftRight(1);
        Real z = (Real)FACTORY.object();
        z._significand = sqrt;
        z._error = maxSqrt.minus(sqrt);
        z._exponent = exponent;
        return z.normalize();
    }

    @Override
    public Text toText() {
        int digits;
        if (this == NaN) {
            return Text.valueOf((Object)"NaN");
        }
        if (this.isExact()) {
            return this._exponent == 0 ? this._significand.toText() : this._significand.toText().plus((Object)"E").plus((Object)Text.valueOf((int)this._exponent));
        }
        int errorDigits = this._error.digitLength();
        LargeInteger m = this._significand.isPositive() ? this._significand.plus(FIVE.times10pow(errorDigits - 1)) : this._significand.plus(MINUS_FIVE.times10pow(errorDigits - 1));
        m = m.times10pow(-errorDigits);
        int exp = this._exponent + errorDigits;
        Text txt = m.toText();
        int n = digits = m.isNegative() ? txt.length() - 1 : txt.length();
        if (digits > 1) {
            if (exp < 0 && -exp < digits) {
                txt = txt.insert(txt.length() + exp, Text.valueOf((char)'.'));
            } else {
                txt = txt.insert(txt.length() - digits + 1, Text.valueOf((char)'.'));
                txt = txt.concat(Text.valueOf((char)'E')).concat(Text.valueOf((int)(exp + digits - 1)));
            }
        } else {
            txt = txt.concat(Text.valueOf((char)'E')).concat(Text.valueOf((int)exp));
        }
        return txt;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof Real)) {
            return false;
        }
        Real thatReal = (Real)that;
        return this._significand.equals(thatReal._significand) && this._error.equals(thatReal._error) && this._exponent == thatReal._exponent;
    }

    @Override
    public int hashCode() {
        return this._significand.hashCode() + this._error.hashCode() + this._exponent * 31;
    }

    @Override
    public long longValue() {
        return (long)this.doubleValue();
    }

    @Override
    public double doubleValue() {
        if (this == NaN) {
            return Double.NaN;
        }
        if (this == ZERO) {
            return 0.0;
        }
        int nbrDigits = this._significand.digitLength();
        int digitShift = nbrDigits - 18;
        long reducedSignificand = this._significand.times10pow(-digitShift).longValue();
        int exponent = this._exponent + digitShift;
        return MathLib.toDoublePow10((long)reducedSignificand, (int)exponent);
    }

    @Override
    public int compareTo(Real that) {
        Real diff = this.minus(that);
        if (diff.isPositive()) {
            return 1;
        }
        if (diff.isNegative()) {
            return -1;
        }
        return 0;
    }

    private Real normalize() {
        int digitError = this._error.digitLength();
        int scale = 9 - digitError;
        if (scale >= 0) {
            return this;
        }
        Real z = (Real)FACTORY.object();
        z._significand = this._significand.times10pow(scale);
        z._error = this._error.times10pow(scale).plus(LargeInteger.ONE);
        z._exponent = this._exponent - scale;
        return z;
    }

    @Override
    public Real copy() {
        if (this == NaN) {
            return NaN;
        }
        return Real.valueOf(this._significand.copy(), this.getError(), this._exponent);
    }

    /* synthetic */ Real(Real real) {
        this();
    }
}

