/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.mathematics.number;

import java.io.IOException;
import javolution.context.ObjectFactory;
import javolution.lang.MathLib;
import javolution.text.Text;
import javolution.text.TextFormat;
import javolution.text.TypeFormat;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.jscience.mathematics.number.Number;
import org.jscience.mathematics.structure.Field;

public final class Complex
extends Number<Complex>
implements Field<Complex> {
    private static final TextFormat<Complex> CARTESIAN_FORMAT = new TextFormat<Complex>(){

        public Appendable format(Complex complex, Appendable appendable) throws IOException {
            TypeFormat.format((double)complex._real, (Appendable)appendable);
            if (complex._imaginary < 0.0) {
                appendable.append(" - ");
                TypeFormat.format((double)(-complex._imaginary), (Appendable)appendable);
            } else {
                appendable.append(" + ");
                TypeFormat.format((double)complex._imaginary, (Appendable)appendable);
            }
            return appendable.append('i');
        }

        public Complex parse(CharSequence csq, TextFormat.Cursor cursor) {
            double real = TypeFormat.parseDouble((CharSequence)csq, (TextFormat.Cursor)cursor);
            cursor.skip(' ', csq);
            char op = cursor.next(csq);
            if (op != '+' && op != '-') {
                throw new NumberFormatException("'+' or '-' expected");
            }
            cursor.skip(' ', csq);
            double imaginary = TypeFormat.parseDouble((CharSequence)csq, (TextFormat.Cursor)cursor);
            char i = cursor.next(csq);
            if (i != 'i') {
                throw new NumberFormatException("'i' expected");
            }
            return Complex.valueOf(real, op == '-' ? -imaginary : imaginary);
        }
    };
    public static final Complex ZERO;
    public static final Complex ONE;
    public static final Complex I;
    static final XMLFormat<Complex> XML;
    private static final ObjectFactory<Complex> FACTORY;
    private double _real;
    private double _imaginary;
    private static final long serialVersionUID = 1L;

    static {
        TextFormat.setInstance(Complex.class, CARTESIAN_FORMAT);
        ZERO = new Complex(0.0, 0.0);
        ONE = new Complex(1.0, 0.0);
        I = new Complex(0.0, 1.0);
        XML = new XMLFormat<Complex>(Complex.class){

            public Complex newInstance(Class<Complex> cls, XMLFormat.InputElement xml) throws XMLStreamException {
                return Complex.valueOf(xml.getAttribute("real", 0.0), xml.getAttribute("imaginary", 0.0));
            }

            public void write(Complex complex, XMLFormat.OutputElement xml) throws XMLStreamException {
                xml.setAttribute("real", complex._real);
                xml.setAttribute("imaginary", complex._imaginary);
            }

            public void read(XMLFormat.InputElement xml, Complex complex) {
            }
        };
        FACTORY = new ObjectFactory<Complex>(){

            protected Complex create() {
                return new Complex(null);
            }
        };
    }

    private Complex() {
    }

    private Complex(double real, double imaginary) {
        this._real = real;
        this._imaginary = imaginary;
    }

    public static Complex valueOf(double real, double imaginary) {
        Complex c = (Complex)FACTORY.object();
        c._real = real;
        c._imaginary = imaginary;
        return c;
    }

    public static Complex valueOf(CharSequence csq) {
        return (Complex)TextFormat.getInstance(Complex.class).parse(csq);
    }

    public boolean isInfinite() {
        return Double.isInfinite(this._real) | Double.isInfinite(this._imaginary);
    }

    public boolean isNaN() {
        return Double.isNaN(this._real) | Double.isNaN(this._imaginary);
    }

    public double getReal() {
        return this._real;
    }

    public double getImaginary() {
        return this._imaginary;
    }

    @Override
    public Complex opposite() {
        Complex c = (Complex)FACTORY.object();
        c._real = -this._real;
        c._imaginary = -this._imaginary;
        return c;
    }

    @Override
    public Complex plus(Complex that) {
        Complex c = (Complex)FACTORY.object();
        c._real = this._real + that._real;
        c._imaginary = this._imaginary + that._imaginary;
        return c;
    }

    @Override
    public Complex minus(Complex that) {
        Complex c = (Complex)FACTORY.object();
        c._real = this._real - that._real;
        c._imaginary = this._imaginary - that._imaginary;
        return c;
    }

    @Override
    public Complex times(double k) {
        Complex c = (Complex)FACTORY.object();
        c._real = this._real * k;
        c._imaginary = this._imaginary * k;
        return c;
    }

    @Override
    public Complex times(Complex that) {
        Complex c = (Complex)FACTORY.object();
        c._real = this._real * that._real - this._imaginary * that._imaginary;
        c._imaginary = this._real * that._imaginary + this._imaginary * that._real;
        return c;
    }

    @Override
    public Complex inverse() {
        Complex c = (Complex)FACTORY.object();
        double tmp = this._real * this._real + this._imaginary * this._imaginary;
        c._real = this._real / tmp;
        c._imaginary = -this._imaginary / tmp;
        return c;
    }

    public Complex divide(double k) {
        Complex c = (Complex)FACTORY.object();
        c._real = this._real / k;
        c._imaginary = this._imaginary / k;
        return c;
    }

    public Complex divide(Complex that) {
        double tmp = that._real * that._real + that._imaginary * that._imaginary;
        double thatInvReal = that._real / tmp;
        double thatInvImaginary = -that._imaginary / tmp;
        Complex c = (Complex)FACTORY.object();
        c._real = this._real * thatInvReal - this._imaginary * thatInvImaginary;
        c._imaginary = this._real * thatInvImaginary + this._imaginary * thatInvReal;
        return c;
    }

    public Complex conjugate() {
        Complex c = (Complex)FACTORY.object();
        c._real = this._real;
        c._imaginary = -this._imaginary;
        return c;
    }

    public double magnitude() {
        return MathLib.sqrt((double)(this._real * this._real + this._imaginary * this._imaginary));
    }

    public double argument() {
        return MathLib.atan2((double)this._imaginary, (double)this._real);
    }

    public Complex sqrt() {
        Complex c = (Complex)FACTORY.object();
        double m = MathLib.sqrt((double)this.magnitude());
        double a = this.argument() / 2.0;
        c._real = m * MathLib.cos((double)a);
        c._imaginary = m * MathLib.sin((double)a);
        return c;
    }

    public Complex exp() {
        Complex c = (Complex)FACTORY.object();
        double m = MathLib.exp((double)this._real);
        c._real = m * MathLib.cos((double)this._imaginary);
        c._imaginary = m * MathLib.sin((double)this._imaginary);
        return c;
    }

    public Complex log() {
        Complex c = (Complex)FACTORY.object();
        c._real = MathLib.log((double)this.magnitude());
        c._imaginary = this.argument();
        return c;
    }

    public Complex pow(double e) {
        Complex c = (Complex)FACTORY.object();
        double m = MathLib.pow((double)this.magnitude(), (double)e);
        double a = this.argument() * e;
        c._real = m * MathLib.cos((double)a);
        c._imaginary = m * MathLib.sin((double)a);
        return c;
    }

    public Complex pow(Complex that) {
        Complex c = (Complex)FACTORY.object();
        double r1 = MathLib.log((double)this.magnitude());
        double i1 = this.argument();
        double r2 = r1 * that._real - i1 * that._imaginary;
        double i2 = r1 * that._imaginary + i1 * that._real;
        double m = MathLib.exp((double)r2);
        c._real = m * MathLib.cos((double)i2);
        c._imaginary = m * MathLib.sin((double)i2);
        return c;
    }

    public boolean equals(Complex that, double tolerance) {
        return MathLib.abs((double)this.minus(that).magnitude()) <= tolerance;
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof Complex && this._real == ((Complex)that)._real && this._imaginary == ((Complex)that)._imaginary;
    }

    @Override
    public int hashCode() {
        int h = Float.floatToIntBits((float)this._real) ^ Float.floatToIntBits((float)(this._imaginary * Math.PI));
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        return h ^ h >>> 10;
    }

    @Override
    public Text toText() {
        return TextFormat.getInstance(Complex.class).format((Object)this);
    }

    @Override
    public long longValue() {
        return (long)this._real;
    }

    @Override
    public double doubleValue() {
        return this._real;
    }

    @Override
    public int compareTo(Complex that) {
        long l2;
        if (this._real < that._real) {
            return -1;
        }
        if (this._real > that._real) {
            return 1;
        }
        long l1 = Double.doubleToLongBits(this._real);
        if (l1 < (l2 = Double.doubleToLongBits(that._real))) {
            return -1;
        }
        if (l2 > l1) {
            return 1;
        }
        if (this._imaginary < that._imaginary) {
            return -1;
        }
        if (this._imaginary > that._imaginary) {
            return 1;
        }
        l1 = Double.doubleToLongBits(this._imaginary);
        if (l1 < (l2 = Double.doubleToLongBits(that._imaginary))) {
            return -1;
        }
        if (l2 > l1) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isLargerThan(Complex that) {
        return this.magnitude() > that.magnitude();
    }

    @Override
    public Complex copy() {
        return Complex.valueOf(this._real, this._imaginary);
    }

    /* synthetic */ Complex(Complex complex) {
        this();
    }
}

