/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.mathematics.function;

import java.util.List;
import java.util.SortedMap;
import javolution.text.Text;
import javolution.util.FastList;
import org.jscience.mathematics.function.Function;
import org.jscience.mathematics.function.FunctionException;
import org.jscience.mathematics.function.Interpolator;
import org.jscience.mathematics.function.Variable;

public final class DiscreteFunction<X, Y>
extends Function<X, Y> {
    private SortedMap<X, Y> _pointValues;
    private FastList<Variable<X>> _variables = new FastList();
    private Interpolator<X, Y> _interpolator;
    private static final long serialVersionUID = 1L;

    public DiscreteFunction(SortedMap<X, Y> pointValues, Interpolator<X, Y> interpolator, Variable<X> variable) {
        this._pointValues = pointValues;
        this._variables.add(variable);
        this._interpolator = interpolator;
    }

    public SortedMap<X, Y> getPointValues() {
        return this._pointValues;
    }

    public Interpolator<X, Y> getInterpolator() {
        return this._interpolator;
    }

    @Override
    public Y evaluate() {
        Object point = ((Variable)this._variables.get(0)).get();
        if (point == null) {
            throw new FunctionException("Variable " + this._variables.get(0) + " not set");
        }
        return this._interpolator.interpolate(point, this._pointValues);
    }

    @Override
    public List<Variable<X>> getVariables() {
        return this._variables;
    }

    @Override
    public Text toText() {
        return Text.valueOf((Object)this.getClass().getName()).plus((Object)"@").plus((Object)Text.valueOf((int)this.hashCode(), (int)16));
    }
}

