/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.geography.coordinates;

import javax.measure.Measure;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import javolution.context.ObjectFactory;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.jscience.geography.coordinates.Coordinates;
import org.jscience.geography.coordinates.LatLong;
import org.jscience.geography.coordinates.crs.CoordinateReferenceSystem;
import org.jscience.geography.coordinates.crs.ProjectedCRS;
import org.jscience.geography.coordinates.crs.ReferenceEllipsoid;
import org.opengis.referencing.cs.CoordinateSystem;

public final class UTM
extends Coordinates<ProjectedCRS<?>> {
    public static final double UTM_SCALE_FACTOR = 0.9996;
    public static Measure<Integer, Length> UTM_FALSE_EASTING = Measure.valueOf(500000, SI.METRE);
    public static Measure<Integer, Length> UTM_FALSE_NORTHING = Measure.valueOf(10000000, SI.METRE);
    public static final Measure<Integer, Angle> UTM_NORTHERN_LIMIT = Measure.valueOf(84, NonSI.DEGREE_ANGLE);
    public static final Measure<Integer, Angle> UTM_SOUTHERN_LIMIT = Measure.valueOf(-80, NonSI.DEGREE_ANGLE);
    public static final double UPS_SCALE_FACTOR = 0.994;
    public static Measure<Integer, Length> UPS_FALSE_EASTING = Measure.valueOf(2000000, SI.METRE);
    public static Measure<Integer, Length> UPS_FALSE_NORTHING = Measure.valueOf(2000000, SI.METRE);
    private static final double K0 = 0.9996;
    private static final double K02 = 0.9992001600000001;
    private static final double K03 = 0.9988004799360002;
    private static final double K04 = 0.9984009597440259;
    private static final double K05 = 0.9980015993601283;
    private static final double K06 = 0.9976023987203844;
    private static final double K07 = 0.9972033577608963;
    private static final double K08 = 0.996804476417792;
    public static final ProjectedCRS<UTM> CRS = new ProjectedCRS<UTM>(){
        private final double NORTHERN_LIMIT_IN_DEGREES = UTM_NORTHERN_LIMIT.doubleValue(NonSI.DEGREE_ANGLE);
        private final double SOUTHERN_LIMIT_IN_DEGREES = UTM_SOUTHERN_LIMIT.doubleValue(NonSI.DEGREE_ANGLE);

        @Override
        protected UTM coordinatesOf(CoordinateReferenceSystem.AbsolutePosition position) {
            LatLong latLong = LatLong.valueOf(position.latitudeWGS84.doubleValue(SI.RADIAN), position.longitudeWGS84.doubleValue(SI.RADIAN), SI.RADIAN);
            double latitude = position.latitudeWGS84.doubleValue(NonSI.DEGREE_ANGLE);
            if (latitude > this.SOUTHERN_LIMIT_IN_DEGREES && latitude < this.NORTHERN_LIMIT_IN_DEGREES) {
                return UTM.latLongToUtm(latLong, ReferenceEllipsoid.WGS84);
            }
            return UTM.latLongToUps(latLong, ReferenceEllipsoid.WGS84);
        }

        @Override
        protected CoordinateReferenceSystem.AbsolutePosition positionOf(UTM coordinates, CoordinateReferenceSystem.AbsolutePosition position) {
            LatLong latLong = coordinates.latitudeZone() < 'C' || coordinates.latitudeZone() > 'X' ? UTM.upsToLatLong(coordinates, ReferenceEllipsoid.WGS84) : UTM.utmToLatLong(coordinates, ReferenceEllipsoid.WGS84);
            position.latitudeWGS84 = Measure.valueOf(latLong.latitudeValue(SI.RADIAN), SI.RADIAN);
            position.longitudeWGS84 = Measure.valueOf(latLong.longitudeValue(SI.RADIAN), SI.RADIAN);
            return position;
        }

        @Override
        public CoordinateSystem getCoordinateSystem() {
            return ProjectedCRS.EASTING_NORTHING_CS;
        }
    };
    private int _longitudeZone;
    private char _latitudeZone;
    private double _easting;
    private double _northing;
    private static final ObjectFactory<UTM> FACTORY = new ObjectFactory<UTM>(){

        protected UTM create() {
            return new UTM(null);
        }
    };
    static final XMLFormat<UTM> XML = new XMLFormat<UTM>(UTM.class){

        public UTM newInstance(Class<UTM> cls, XMLFormat.InputElement xml) throws XMLStreamException {
            return (UTM)FACTORY.object();
        }

        public void write(UTM utm, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("latitudeZone", utm._latitudeZone);
            xml.setAttribute("longitudeZone", utm._longitudeZone);
            xml.setAttribute("easting", utm._easting);
            xml.setAttribute("northing", utm._northing);
        }

        public void read(XMLFormat.InputElement xml, UTM UTM2) throws XMLStreamException {
            UTM2._latitudeZone = xml.getAttribute("latitudeZone", ' ');
            UTM2._longitudeZone = xml.getAttribute("longitudeZone", 0);
            UTM2._easting = xml.getAttribute("easting", 0.0);
            UTM2._northing = xml.getAttribute("northing", 0.0);
        }
    };
    private static final long serialVersionUID = 1L;

    public static UTM valueOf(int longitudeZone, char latitudeZone, double easting, double northing, Unit<Length> unit) {
        UTM utm = (UTM)FACTORY.object();
        utm._longitudeZone = longitudeZone;
        utm._latitudeZone = latitudeZone;
        if (unit == SI.METRE) {
            utm._easting = easting;
            utm._northing = northing;
        } else {
            UnitConverter toMeter = unit.getConverterTo(SI.METRE);
            utm._easting = toMeter.convert(easting);
            utm._northing = toMeter.convert(northing);
        }
        return utm;
    }

    private UTM() {
    }

    public final int longitudeZone() {
        return this._longitudeZone;
    }

    public final char latitudeZone() {
        return this._latitudeZone;
    }

    public final double eastingValue(Unit<Length> unit) {
        return unit.equals(SI.METRE) ? this._easting : SI.METRE.getConverterTo(unit).convert(this._easting);
    }

    public final double northingValue(Unit<Length> unit) {
        return unit.equals(SI.METRE) ? this._northing : SI.METRE.getConverterTo(unit).convert(this._northing);
    }

    @Override
    public ProjectedCRS<UTM> getCoordinateReferenceSystem() {
        return CRS;
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public double getOrdinate(int dimension) throws IndexOutOfBoundsException {
        if (dimension == 0) {
            Unit<?> u = ProjectedCRS.EASTING_NORTHING_CS.getAxis(0).getUnit();
            return SI.METRE.getConverterTo(u).convert(this._easting);
        }
        if (dimension == 1) {
            Unit<?> u = ProjectedCRS.EASTING_NORTHING_CS.getAxis(1).getUnit();
            return SI.METRE.getConverterTo(u).convert(this._northing);
        }
        throw new IndexOutOfBoundsException();
    }

    public static boolean isNorthPolar(LatLong latLong) {
        return latLong.latitudeValue(NonSI.DEGREE_ANGLE) > 84.0;
    }

    public static boolean isSouthPolar(LatLong latLong) {
        return latLong.latitudeValue(NonSI.DEGREE_ANGLE) < -80.0;
    }

    public static char getLatitudeZone(LatLong latLong) {
        if (UTM.isNorthPolar(latLong)) {
            if (latLong.longitudeValue(SI.RADIAN) < 0.0) {
                return 'Y';
            }
            return 'Z';
        }
        if (UTM.isSouthPolar(latLong)) {
            if (latLong.longitudeValue(SI.RADIAN) < 0.0) {
                return 'A';
            }
            return 'B';
        }
        int degreesLatitude = (int)latLong.latitudeValue(NonSI.DEGREE_ANGLE);
        char zone = (char)((degreesLatitude + 80) / 8 + 67);
        if (zone > 'H') {
            zone = (char)(zone + '\u0001');
        }
        if (zone > 'N') {
            zone = (char)(zone + '\u0001');
        }
        if (zone > 'X') {
            zone = 'X';
        }
        return (char)zone;
    }

    public static int getLongitudeZone(LatLong latLong) {
        double degreesLongitude = latLong.longitudeValue(NonSI.DEGREE_ANGLE);
        if (UTM.isNorthPolar(latLong) || UTM.isSouthPolar(latLong)) {
            if (degreesLongitude < 0.0) {
                return 30;
            }
            return 31;
        }
        char latitudeZone = UTM.getLatitudeZone(latLong);
        if (latitudeZone == 'X' && degreesLongitude > 0.0 && degreesLongitude < 42.0) {
            if (degreesLongitude < 9.0) {
                return 31;
            }
            if (degreesLongitude < 21.0) {
                return 33;
            }
            if (degreesLongitude < 33.0) {
                return 35;
            }
            return 37;
        }
        if (latitudeZone == 'V' && degreesLongitude > 0.0 && degreesLongitude < 12.0) {
            if (degreesLongitude < 3.0) {
                return 31;
            }
            return 32;
        }
        return (int)((degreesLongitude + 180.0) / 6.0) + 1;
    }

    public static double getCentralMeridian(int longitudeZone, char latitudeZone) {
        if (latitudeZone < 'C' || latitudeZone > 'X') {
            return 0.0;
        }
        if (latitudeZone == 'X' && longitudeZone > 31 && longitudeZone <= 37) {
            return Math.toRadians((double)((longitudeZone - 1) * 6 - 180) + 4.5);
        }
        if (longitudeZone == 86) {
            if (latitudeZone == '\u001f') {
                return Math.toRadians(1.5);
            }
            if (latitudeZone == ' ') {
                return Math.toRadians(7.5);
            }
        }
        return Math.toRadians((longitudeZone - 1) * 6 - 180 + 3);
    }

    public static UTM latLongToUtm(LatLong latLong, ReferenceEllipsoid ellipsoid) {
        char latitudeZone = UTM.getLatitudeZone(latLong);
        int longitudeZone = UTM.getLongitudeZone(latLong);
        double phi = latLong.latitudeValue(SI.RADIAN);
        double cosPhi = Math.cos(phi);
        double cos2Phi = cosPhi * cosPhi;
        double cos3Phi = cos2Phi * cosPhi;
        double cos4Phi = cos3Phi * cosPhi;
        double cos5Phi = cos4Phi * cosPhi;
        double cos6Phi = cos5Phi * cosPhi;
        double cos7Phi = cos6Phi * cosPhi;
        double cos8Phi = cos7Phi * cosPhi;
        double tanPhi = Math.tan(phi);
        double tan2Phi = tanPhi * tanPhi;
        double tan4Phi = tan2Phi * tan2Phi;
        double tan6Phi = tan4Phi * tan2Phi;
        double eb2 = ellipsoid.getSecondEccentricitySquared();
        double eb4 = eb2 * eb2;
        double eb6 = eb4 * eb2;
        double eb8 = eb6 * eb2;
        double e2c2 = eb2 * cos2Phi;
        double e4c4 = eb4 * cos4Phi;
        double e6c6 = eb6 * cos6Phi;
        double e8c8 = eb8 * cos8Phi;
        double t2e2c2 = tan2Phi * e2c2;
        double t2e4c4 = tan2Phi * e4c4;
        double t2e6c6 = tan2Phi * e6c6;
        double t2e8c8 = tan2Phi * e8c8;
        double nu = ellipsoid.verticalRadiusOfCurvature(phi);
        double kn1 = 0.9996 * nu * Math.sin(phi);
        double t1 = 0.9996 * ellipsoid.meridionalArc(phi);
        double t2 = kn1 * cosPhi / 2.0;
        double t3 = kn1 * cos3Phi / 24.0 * (5.0 - tan2Phi + 9.0 * e2c2 + 4.0 * e4c4);
        double t4 = kn1 * cos5Phi / 720.0 * (61.0 - 58.0 * tan2Phi + tan4Phi + 270.0 * e2c2 - 330.0 * t2e2c2 + 445.0 * e4c4 - 680.0 * t2e4c4 + 324.0 * e6c6 - 600.0 * t2e6c6 + 88.0 * e8c8 - 192.0 * t2e8c8);
        double t5 = kn1 * cos7Phi / 40320.0 * (1385.0 - 3111.0 * tan2Phi + 543.0 * tan4Phi - tan6Phi);
        double kn2 = 0.9996 * nu;
        double t6 = kn2 * cosPhi;
        double t7 = kn2 * cos3Phi / 6.0 * (1.0 - tan2Phi + e2c2);
        double t8 = kn2 * cos5Phi / 120.0 * (5.0 - 18.0 * tan2Phi + tan4Phi + 14.0 * e2c2 - 58.0 * t2e2c2 + 13.0 * e4c4 - 64.0 * t2e4c4 + 4.0 * e6c6 - 24.0 * t2e6c6);
        double t9 = kn2 * cos7Phi / 50.4 * (61.0 - 479.0 * tan2Phi + 179.0 * tan4Phi - tan6Phi);
        double lambda = latLong.longitudeValue(SI.RADIAN);
        double lambda0 = UTM.getCentralMeridian(longitudeZone, latitudeZone);
        double dL = lambda - lambda0;
        double dL2 = dL * dL;
        double dL3 = dL2 * dL;
        double dL4 = dL3 * dL;
        double dL5 = dL4 * dL;
        double dL6 = dL5 * dL;
        double dL7 = dL6 * dL;
        double dL8 = dL7 * dL;
        double falseNorthing = phi < 0.0 ? UTM_FALSE_NORTHING.doubleValue(SI.METRE) : 0.0;
        double falseEasting = UTM_FALSE_EASTING.doubleValue(SI.METRE);
        double northing = falseNorthing + t1 + dL2 * t2 + dL4 * t3 + dL6 * t4 + dL8 * t5;
        double easting = falseEasting + dL * t6 + dL3 * t7 + dL5 * t8 + dL7 * t9;
        return UTM.valueOf(longitudeZone, latitudeZone, easting, northing, SI.METRE);
    }

    public static UTM latLongToUps(LatLong latLong, ReferenceEllipsoid ellipsoid) {
        char latitudeZone = UTM.getLatitudeZone(latLong);
        int longitudeZone = UTM.getLongitudeZone(latLong);
        double latitude = latLong.latitudeValue(SI.RADIAN);
        double sign = Math.signum(latitude);
        double phi = Math.abs(latitude);
        double lambda = latLong.longitudeValue(SI.RADIAN);
        double a = ellipsoid.getSemimajorAxis().doubleValue(SI.METRE);
        double e = ellipsoid.getEccentricity();
        double e2 = ellipsoid.getEccentricitySquared();
        double c0 = 2.0 * a / Math.sqrt(1.0 - e2) * Math.pow((1.0 - e) / (1.0 + e), e / 2.0);
        double eSinPhi = e * Math.sin(phi);
        double tz = Math.pow((1.0 + eSinPhi) / (1.0 - eSinPhi), e / 2.0) * Math.tan(0.7853981633974483 - phi / 2.0);
        double radius = 0.994 * c0 * tz;
        double falseNorthing = UPS_FALSE_NORTHING.doubleValue(SI.METRE);
        double northing = sign > 0.0 ? falseNorthing - radius * Math.cos(lambda) : falseNorthing + radius * Math.cos(lambda);
        double falseEasting = UPS_FALSE_EASTING.doubleValue(SI.METRE);
        double easting = falseEasting + radius * Math.sin(lambda);
        return UTM.valueOf(longitudeZone, latitudeZone, easting, northing, SI.METRE);
    }

    public static LatLong utmToLatLong(UTM utm, ReferenceEllipsoid ellipsoid) {
        double northing = utm.latitudeZone() < 'N' ? utm._northing - UTM_FALSE_NORTHING.doubleValue(SI.METRE) : utm._northing;
        double arc0 = northing / 0.9996;
        double rho = ellipsoid.meridionalRadiusOfCurvature(0.0);
        double phi = arc0 / rho;
        int i = 0;
        while (i < 5) {
            double arc = ellipsoid.meridionalArc(phi);
            double diff = (arc0 - arc) / (rho = ellipsoid.meridionalRadiusOfCurvature(phi));
            if (Math.abs(diff) < Math.ulp(phi)) break;
            phi += diff;
            ++i;
        }
        double cosPhi = Math.cos(phi);
        double cos2Phi = cosPhi * cosPhi;
        double cos3Phi = cos2Phi * cosPhi;
        double cos4Phi = cos3Phi * cosPhi;
        double cos5Phi = cos4Phi * cosPhi;
        double cos6Phi = cos5Phi * cosPhi;
        double cos7Phi = cos6Phi * cosPhi;
        double cos8Phi = cos7Phi * cosPhi;
        double tanPhi = Math.tan(phi);
        double tan2Phi = tanPhi * tanPhi;
        double tan4Phi = tan2Phi * tan2Phi;
        double tan6Phi = tan4Phi * tan2Phi;
        double eb2 = ellipsoid.getSecondEccentricitySquared();
        double eb4 = eb2 * eb2;
        double eb6 = eb4 * eb2;
        double eb8 = eb6 * eb2;
        double e2c2 = eb2 * cos2Phi;
        double e4c4 = eb4 * cos4Phi;
        double e6c6 = eb6 * cos6Phi;
        double e8c8 = eb8 * cos8Phi;
        double t2e2c2 = tan2Phi * e2c2;
        double t2e4c4 = tan2Phi * e4c4;
        double t2e6c6 = tan2Phi * e6c6;
        double t2e8c8 = tan2Phi * e8c8;
        double t4e2c2 = tan4Phi * e2c2;
        double t4e4c4 = tan4Phi * e4c4;
        double nu = ellipsoid.verticalRadiusOfCurvature(phi);
        double nu2 = nu * nu;
        double nu3 = nu2 * nu;
        double nu5 = nu3 * nu2;
        double nu7 = nu5 * nu2;
        double lambda0 = UTM.getCentralMeridian(utm.longitudeZone(), utm.latitudeZone());
        double dE = utm._easting - UTM_FALSE_EASTING.doubleValue(SI.METRE);
        double dE2 = dE * dE;
        double dE3 = dE2 * dE;
        double dE4 = dE3 * dE;
        double dE5 = dE4 * dE;
        double dE6 = dE5 * dE;
        double dE7 = dE6 * dE;
        double dE8 = dE7 * dE;
        double t10 = tanPhi / (2.0 * rho * nu * 0.9992001600000001);
        double t11 = tanPhi / (24.0 * rho * nu3 * 0.9984009597440259) * (5.0 + 3.0 * tan2Phi + e2c2 - 9.0 * t2e2c2 - 4.0 * e4c4);
        double t12 = tanPhi / (720.0 * rho * nu5 * 0.9976023987203844) * (61.0 + 90.0 * tan2Phi + 45.0 * tan4Phi + 46.0 * e2c2 - 252.0 * t2e2c2 - 90.0 * t4e2c2 - 3.0 * e4c4 - 66.0 * t2e4c4 + 225.0 * t4e4c4 + 100.0 * e6c6 + 84.0 * t2e6c6 + 88.0 * e8c8 - 192.0 * t2e8c8);
        double t13 = tanPhi / (40320.0 * rho * nu7 * 0.996804476417792) * (1385.0 + 3633.0 * tan2Phi + 4095.0 * tan4Phi + 1575.0 * tan6Phi);
        double t14 = 1.0 / (cosPhi * nu * 0.9996);
        double t15 = 1.0 / (6.0 * cosPhi * nu3 * 0.9988004799360002) * (1.0 + 2.0 * tan2Phi + e2c2);
        double t16 = 1.0 / (120.0 * cosPhi * nu5 * 0.9980015993601283) * (5.0 + 28.0 * tan2Phi + 24.0 * tan4Phi + 6.0 * e2c2 + 8.0 * t2e2c2 - 3.0 * e4c4 + 4.0 * t2e4c4 - 4.0 * e6c6 + 24.0 * t2e6c6);
        double t17 = 1.0 / (5040.0 * cosPhi * nu7 * 0.9972033577608963) * (61.0 + 662.0 * tan2Phi + 1320.0 * tan4Phi + 720.0 * tan6Phi);
        double latitude = phi - dE2 * t10 + dE4 * t11 - dE6 * t12 + dE8 * t13;
        double longitude = lambda0 + dE * t14 - dE3 * t15 + dE5 * t16 - dE7 * t17;
        return LatLong.valueOf(latitude, longitude, SI.RADIAN);
    }

    public static LatLong upsToLatLong(UTM ups, ReferenceEllipsoid ellipsoid) {
        boolean northernHemisphere = ups.latitudeZone() > 'N';
        double dN = ups.northingValue(SI.METRE) - UPS_FALSE_NORTHING.doubleValue(SI.METRE);
        double dE = ups.eastingValue(SI.METRE) - UPS_FALSE_EASTING.doubleValue(SI.METRE);
        if (dE == 0.0 && dN == 0.0) {
            if (northernHemisphere) {
                return LatLong.valueOf(90.0, 0.0, NonSI.DEGREE_ANGLE);
            }
            return LatLong.valueOf(-90.0, 0.0, NonSI.DEGREE_ANGLE);
        }
        double longitude = northernHemisphere ? Math.atan2(dE, -dN) : Math.atan2(dE, dN);
        double a = ellipsoid.getSemimajorAxis().doubleValue(SI.METRE);
        double e = ellipsoid.getEccentricity();
        double e2 = ellipsoid.getEccentricitySquared();
        double e4 = e2 * e2;
        double e6 = e4 * e2;
        double e8 = e6 * e2;
        double aBar = e2 / 2.0 + 5.0 * e4 / 24.0 + e6 / 12.0 + 13.0 * e8 / 360.0;
        double bBar = 7.0 * e4 / 48.0 + 29.0 * e6 / 240.0 + 811.0 * e8 / 11520.0;
        double cBar = 7.0 * e6 / 120.0 + 81.0 * e8 / 1120.0;
        double dBar = 4279.0 * e8 / 161280.0;
        double c0 = 2.0 * a / Math.sqrt(1.0 - e2) * Math.pow((1.0 - e) / (1.0 + e), e / 2.0);
        double r = dE == 0.0 ? dN : (dN == 0.0 ? dE : (dN < dE ? dE / Math.sin(longitude) : dN / Math.cos(longitude)));
        double radius = Math.abs(r);
        double chi = 1.5707963267948966 - 2.0 * Math.atan2(radius, 0.994 * c0);
        double phi = chi + aBar * Math.sin(2.0 * chi) + bBar * Math.sin(4.0 * chi) + cBar * Math.sin(6.0 * chi) + dBar * Math.sin(8.0 * chi);
        double latitude = northernHemisphere ? phi : -phi;
        return LatLong.valueOf(latitude, longitude, SI.RADIAN);
    }

    @Override
    public UTM copy() {
        return UTM.valueOf(this._longitudeZone, this._latitudeZone, this._easting, this._northing, SI.METRE);
    }

    /* synthetic */ UTM(UTM uTM) {
        this();
    }
}

