/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.geography.coordinates;

import javax.measure.Measurable;
import javax.measure.quantity.Length;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import javolution.context.ObjectFactory;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.jscience.geography.coordinates.Coordinates;
import org.jscience.geography.coordinates.crs.CoordinateReferenceSystem;
import org.jscience.geography.coordinates.crs.VerticalCRS;
import org.opengis.referencing.cs.CoordinateSystem;

public final class Height
extends Coordinates<VerticalCRS<?>>
implements Measurable<Length> {
    public static final VerticalCRS<Height> CRS = new VerticalCRS<Height>(){

        @Override
        protected Height coordinatesOf(CoordinateReferenceSystem.AbsolutePosition position) {
            if (position.heightWGS84 instanceof Height) {
                return (Height)position.heightWGS84;
            }
            return Height.valueOf(position.heightWGS84.doubleValue(SI.METRE), SI.METRE);
        }

        @Override
        protected CoordinateReferenceSystem.AbsolutePosition positionOf(Height coordinates, CoordinateReferenceSystem.AbsolutePosition position) {
            position.heightWGS84 = coordinates;
            return position;
        }

        @Override
        public CoordinateSystem getCoordinateSystem() {
            return VerticalCRS.HEIGHT_CS;
        }
    };
    private double _meters;
    private static final ObjectFactory<Height> FACTORY = new ObjectFactory<Height>(){

        protected Height create() {
            return new Height(null);
        }
    };
    static final XMLFormat<Height> XML = new XMLFormat<Height>(Height.class){

        public Height newInstance(Class<Height> cls, XMLFormat.InputElement xml) throws XMLStreamException {
            return (Height)FACTORY.object();
        }

        public void write(Height height, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("meters", height._meters);
        }

        public void read(XMLFormat.InputElement xml, Height height) throws XMLStreamException {
            height._meters = xml.getAttribute("meters", 0.0);
        }
    };
    private static final long serialVersionUID = 1L;

    public static Height valueOf(double value, Unit<Length> unit) {
        Height height = (Height)FACTORY.object();
        height._meters = unit == SI.METRE ? value : unit.getConverterTo(SI.METRE).convert(value);
        return height;
    }

    private Height() {
    }

    @Override
    public VerticalCRS<?> getCoordinateReferenceSystem() {
        return CRS;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double getOrdinate(int dimension) throws IndexOutOfBoundsException {
        if (dimension == 0) {
            Unit<?> u = VerticalCRS.HEIGHT_CS.getAxis(0).getUnit();
            return SI.METRE.getConverterTo(u).convert(this._meters);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final double doubleValue(Unit<Length> unit) {
        return unit.equals(SI.METRE) ? this._meters : SI.METRE.getConverterTo(unit).convert(this._meters);
    }

    @Override
    public final long longValue(Unit<Length> unit) {
        return Math.round(this.doubleValue(unit));
    }

    @Override
    public int compareTo(Measurable<Length> arg0) {
        double arg0InMeter = arg0.doubleValue(SI.METRE);
        return this._meters > arg0InMeter ? 1 : (this._meters < arg0InMeter ? -1 : 0);
    }

    @Override
    public Height copy() {
        return Height.valueOf(this._meters, SI.METRE);
    }

    /* synthetic */ Height(Height height) {
        this();
    }
}

