/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.geography.coordinates;

import javolution.lang.Realtime;
import javolution.lang.ValueType;
import javolution.text.Text;
import javolution.text.TextBuilder;
import javolution.xml.XMLSerializable;
import org.jscience.geography.coordinates.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.spatialschema.geometry.DirectPosition;

public abstract class Coordinates<R extends CoordinateReferenceSystem<?>>
implements DirectPosition,
Realtime,
ValueType,
XMLSerializable {
    protected Coordinates() {
    }

    public abstract R getCoordinateReferenceSystem();

    public abstract int getDimension();

    public abstract double getOrdinate(int var1) throws IndexOutOfBoundsException;

    public final void setOrdinate(int dimension, double value) throws IndexOutOfBoundsException {
        throw new UnsupportedOperationException("Immutable coordinates");
    }

    public final double[] getCoordinates() {
        double[] coordinates = new double[this.getDimension()];
        int i = 0;
        while (i < coordinates.length) {
            coordinates[i] = this.getOrdinate(i);
            ++i;
        }
        return coordinates;
    }

    public final DirectPosition getPosition() {
        return this;
    }

    public final Coordinates<R> clone() {
        return this.clone();
    }

    public Text toText() {
        double[] coordinates = this.getCoordinates();
        CoordinateSystem cs = this.getCoordinateReferenceSystem().getCoordinateSystem();
        TextBuilder tb = TextBuilder.newInstance();
        tb.append('[');
        int i = 0;
        while (i < coordinates.length) {
            if (i != 0) {
                tb.append(", ");
            }
            tb.append(this.getOrdinate(i));
            tb.append(' ');
            tb.append(cs.getAxis(i).getUnit());
            ++i;
        }
        tb.append(']');
        return tb.toText();
    }

    public final String toString() {
        return this.toText().toString();
    }

    public abstract Coordinates<?> copy();
}

