/*
 * Decompiled with CFR 0.152.
 */
package org.jscience;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import javax.measure.quantity.Duration;
import javax.measure.quantity.ElectricCurrent;
import javax.measure.quantity.ElectricPotential;
import javax.measure.quantity.ElectricResistance;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Length;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Quantity;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Velocity;
import javax.measure.quantity.Volume;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;
import javolution.context.ConcurrentContext;
import javolution.context.LocalContext;
import javolution.context.StackContext;
import javolution.lang.Configurable;
import javolution.lang.MathLib;
import javolution.text.TextBuilder;
import org.jscience.economics.money.Currency;
import org.jscience.economics.money.Money;
import org.jscience.geography.coordinates.Altitude;
import org.jscience.geography.coordinates.CompoundCoordinates;
import org.jscience.geography.coordinates.LatLong;
import org.jscience.geography.coordinates.Time;
import org.jscience.geography.coordinates.UTM;
import org.jscience.geography.coordinates.XYZ;
import org.jscience.geography.coordinates.crs.CoordinatesConverter;
import org.jscience.mathematics.function.Polynomial;
import org.jscience.mathematics.function.Variable;
import org.jscience.mathematics.number.Complex;
import org.jscience.mathematics.number.Float64;
import org.jscience.mathematics.number.LargeInteger;
import org.jscience.mathematics.number.ModuloInteger;
import org.jscience.mathematics.number.Rational;
import org.jscience.mathematics.number.Real;
import org.jscience.mathematics.structure.Field;
import org.jscience.mathematics.vector.ComplexMatrix;
import org.jscience.mathematics.vector.DenseMatrix;
import org.jscience.mathematics.vector.DenseVector;
import org.jscience.mathematics.vector.Float64Matrix;
import org.jscience.mathematics.vector.Matrix;
import org.jscience.mathematics.vector.Vector;
import org.jscience.physics.amount.Amount;
import org.jscience.physics.amount.AmountFormat;
import org.jscience.physics.model.RelativisticModel;

public final class JScience {
    public static final String VERSION = "@VERSION@";
    public static Configurable<Character> MODULO = new Configurable((Object)Character.valueOf('w'));
    private static long _time;

    private JScience() {
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Version @VERSION@ (http://jscience.org)");
        System.out.println("");
        if (args.length > 0) {
            if (args[0].equals("version")) {
                System.out.println("Version @VERSION@");
                return;
            }
            if (args[0].equals("test")) {
                JScience.testing();
                return;
            }
            if (args[0].equals("perf")) {
                JScience.benchmark();
                return;
            }
        }
        System.out.println("Usage: java [-cp javolution.jar] -jar jscience.jar [arg]");
        System.out.println("where arg is one of:");
        System.out.println("    version (to show version information)");
        System.out.println("    test    (to perform self-tests)");
        System.out.println("    perf    (to run benchmark)");
    }

    private static void testing() throws Exception {
        System.out.println("Load Configurable Parameters from System.getProperties()...");
        Configurable.read((Map)System.getProperties());
        System.out.println("");
        System.out.println("Testing...");
        System.out.println("");
        System.out.println("Exact Measurements");
        Amount<Mass> m0 = Amount.valueOf(100L, NonSI.POUND);
        Amount<Mass> m1 = m0.times(33L).divide(2L);
        Amount<ElectricCurrent> m2 = Amount.valueOf("234 mA").to(SI.MICRO(SI.AMPERE));
        System.out.println("m0 = " + m0);
        System.out.println("m1 = " + m1);
        System.out.println("m2 = " + m2);
        System.out.println("");
        System.out.println("Inexact Measurements");
        Amount<Mass> m3 = Amount.valueOf(100.0, NonSI.POUND);
        Amount<Mass> m4 = m0.divide(3L);
        Amount<ElectricCurrent> m5 = Amount.valueOf("234 mA").to(SI.AMPERE);
        Amount<Temperature> t0 = Amount.valueOf(-7.3, 0.5, SI.CELSIUS);
        System.out.println("m3 = " + m3);
        System.out.println("m4 = " + m4);
        System.out.println("m5 = " + m5);
        System.out.println("t0 = " + t0);
        System.out.println("");
        System.out.println("Interval measurements");
        Amount<Volume> m6 = Amount.valueOf(20.0, 0.1, NonSI.LITRE);
        Amount<Frequency> m7 = Amount.rangeOf(10.0, 11.0, SI.KILO(SI.HERTZ));
        System.out.println("m6 = " + m6);
        System.out.println("m7 = " + m7);
        System.out.println("");
        System.out.println("Amount.equals (identical) / Amount.approximates (takes into account errors such as numeric errors)");
        Amount<Frequency> m8 = Amount.valueOf(9000L, SI.HERTZ);
        Amount<Frequency> m10 = m8.divide(3L).times(3L);
        Amount<Frequency> m11 = m8.divide(7L).times(7L);
        System.out.println("m8 = " + m8);
        System.out.println("m10 = " + m10);
        System.out.println("m11 = " + m11);
        System.out.println("(m10 == m8) = " + m10.equals(m8));
        System.out.println("(m10 \u2245 m8) = " + m10.approximates(m8));
        System.out.println("(m11 == m8) = " + m11.equals(m8));
        System.out.println("(m11 \u2245 m8) = " + m11.approximates(m8));
        System.out.println("");
        System.out.println("AmountFormat - Plus/Minus Error (3 digits error)");
        AmountFormat.setInstance(AmountFormat.getPlusMinusErrorInstance(3));
        System.out.println("m3 = " + m3);
        System.out.println("m4 = " + m4);
        System.out.println("m5 = " + m5);
        System.out.println("");
        System.out.println("AmountFormat - Bracket Error (2 digits error)");
        AmountFormat.setInstance(AmountFormat.getBracketErrorInstance(2));
        System.out.println("m3 = " + m3);
        System.out.println("m4 = " + m4);
        System.out.println("m5 = " + m5);
        System.out.println("");
        System.out.println("AmountFormat - Exact Digits Only");
        AmountFormat.setInstance(AmountFormat.getExactDigitsInstance());
        System.out.println("m3 = " + m3);
        System.out.println("m4 = " + m4);
        System.out.println("m5 = " + m5);
        System.out.println("");
        System.out.println("Numeric Errors");
        Amount<Length> x = Amount.valueOf(1.0, SI.METRE);
        Amount<Velocity> v = Amount.valueOf(0.01, SI.METRES_PER_SECOND);
        Amount<Duration> t = Amount.valueOf(1.0, SI.MICRO(SI.SECOND));
        long ns = System.nanoTime();
        int i = 0;
        while (i < 10000000) {
            x = x.plus(v.times(t));
            ++i;
        }
        ns = System.nanoTime() - ns;
        AmountFormat.setInstance(AmountFormat.getExactDigitsInstance());
        System.out.println(x + " (" + Amount.valueOf(ns, 0.5, SI.NANO(SI.SECOND)).to(SI.MILLI(SI.SECOND)) + ")");
        double x2 = 1.0;
        double v2 = 0.01;
        double t2 = 1.0E-6;
        int i2 = 0;
        while (i2 < 10000000) {
            x2 += v2 * t2;
            ++i2;
        }
        System.out.println(x2);
        AmountFormat.setInstance(AmountFormat.getPlusMinusErrorInstance(2));
        System.out.println("");
        System.out.println("Physical Models");
        RelativisticModel.select();
        Amount<Length> x3 = Amount.valueOf(100L, NonSI.INCH);
        x3 = x3.plus(Amount.valueOf("2.3 \u00b5s")).to(SI.METRE);
        System.out.println(x3);
        Amount<Mass> m = Amount.valueOf("12 GeV").to(SI.KILOGRAM);
        System.out.println(m);
        System.out.println("");
        System.out.println("Money/Currencies");
        UnitFormat.getInstance().label(Currency.USD, "$");
        UnitFormat.getInstance().label(Currency.EUR, "\u20ac");
        Currency.setReferenceCurrency(Currency.USD);
        Currency.EUR.setExchangeRate(1.17);
        Amount<Quantity> carMileage = Amount.valueOf(20L, NonSI.MILE.divide(NonSI.GALLON_LIQUID_US));
        Amount<Quantity> gazPrice = Amount.valueOf(1.2, Currency.EUR.divide(NonSI.LITRE));
        Amount<Length> tripDistance = Amount.valueOf(400L, SI.KILO(SI.METRE));
        Amount<Money> tripCost = tripDistance.divide(carMileage).times(gazPrice).to(Currency.USD);
        System.out.println("Trip cost = " + tripCost + " (" + tripCost.to(Currency.EUR) + ")");
        System.out.println("");
        System.out.println("Matrices/Vectors");
        Amount<ElectricResistance> R1 = Amount.valueOf(100.0, 1.0, SI.OHM);
        Amount<ElectricResistance> R2 = Amount.valueOf(300.0, 3.0, SI.OHM);
        Amount<ElectricPotential> U0 = Amount.valueOf(28.0, 0.01, SI.VOLT);
        DenseMatrix A = DenseMatrix.valueOf((Field[][])new Amount[][]{{Amount.ONE, Amount.ONE, Amount.valueOf(0L, SI.OHM)}, {Amount.ONE.opposite(), Amount.ZERO, R1}, {Amount.ZERO, Amount.ONE.opposite(), R2}});
        DenseVector B = DenseVector.valueOf((Field[])new Amount[]{U0, Amount.valueOf(0L, SI.VOLT), Amount.valueOf(0L, SI.VOLT)});
        Vector X = A.solve(B);
        System.out.println(X);
        System.out.println(((Amount)X.get(2)).to(SI.MILLI(SI.AMPERE)));
        System.out.println("");
        System.out.println("Polynomials");
        Variable.Local varX = new Variable.Local("x");
        Variable.Local varY = new Variable.Local("y");
        Polynomial<Complex> x4 = Polynomial.valueOf(Complex.ONE, varX);
        Polynomial<Complex> fx = ((Polynomial)x4.pow(2)).times(Complex.I).plus(x4.times(Complex.valueOf(2.0, 0.0)).plus(Complex.ONE));
        System.out.println(fx);
        System.out.println(fx.pow(2));
        System.out.println(fx.differentiate((Variable)varX));
        System.out.println(fx.integrate((Variable)varY));
        System.out.println(fx.compose(fx));
        varX.set(Complex.valueOf(2.0, 3.0));
        System.out.println(fx.evaluate());
        System.out.println("");
        System.out.println("Coordinates Conversions");
        CoordinatesConverter latLongToUTM = LatLong.CRS.getConverterTo(UTM.CRS);
        LatLong latLong = LatLong.valueOf(34.34, 23.56, NonSI.DEGREE_ANGLE);
        UTM utm = latLongToUTM.convert(latLong);
        System.out.println(utm);
        CoordinatesConverter latLongToXYZ = LatLong.CRS.getConverterTo(XYZ.CRS);
        XYZ xyz = latLongToXYZ.convert(latLong);
        System.out.println(xyz);
        Altitude alt = Altitude.valueOf(2000.0, NonSI.FOOT);
        CompoundCoordinates<LatLong, Altitude> latLongAlt = CompoundCoordinates.valueOf(latLong, alt);
        xyz = latLongAlt.getCoordinateReferenceSystem().getConverterTo(XYZ.CRS).convert(latLongAlt);
        System.out.println(xyz);
        Time time = Time.valueOf(new Date());
        CompoundCoordinates<CompoundCoordinates<LatLong, Altitude>, Time> latLongAltTime = CompoundCoordinates.valueOf(latLongAlt, time);
        System.out.println(latLongAltTime);
        System.out.println("");
        System.out.println("Numbers");
        Real two = Real.valueOf(2L);
        Real three = Real.valueOf(3L);
        Real.setExactPrecision(100);
        System.out.println("2/3       = " + two.divide(three));
        Real sqrt2 = two.sqrt();
        System.out.println("sqrt(2)   = " + sqrt2);
        System.out.println("Precision = " + sqrt2.getPrecision() + " digits.");
        LargeInteger dividend = LargeInteger.valueOf("3133861182986538201");
        LargeInteger divisor = LargeInteger.valueOf("25147325102501733369");
        Rational rational = Rational.valueOf(dividend, divisor);
        System.out.println("rational  = " + rational);
        ModuloInteger m9 = ModuloInteger.valueOf("233424242346");
        LocalContext.enter();
        try {
            ModuloInteger.setModulus(LargeInteger.valueOf("31225208137"));
            ModuloInteger inv = m9.inverse();
            System.out.println("inverse modulo = " + inv);
            ModuloInteger one = inv.times(m9);
            System.out.println("verification: one = " + one);
        }
        finally {
            LocalContext.exit();
        }
    }

    private static void benchmark() throws Exception {
        int j;
        int j2;
        Serializable x;
        System.out.println("Load Configurable Parameters from System.getProperties()...");
        Configurable.read((Map)System.getProperties());
        System.out.println("");
        System.out.println("Benchmark...");
        Object[] results = new Object[10000];
        System.out.println("");
        System.out.println("Numerics Operations");
        System.out.print("Float64 add: ");
        JScience.startTime();
        int i = 0;
        while (i < 10000) {
            StackContext.enter();
            x = Float64.ONE;
            j2 = 0;
            while (j2 < results.length) {
                results[j2] = ((Float64)x).plus((Float64)x);
                ++j2;
            }
            StackContext.exit();
            ++i;
        }
        JScience.endTime(10000 * results.length);
        System.out.print("Float64 multiply: ");
        JScience.startTime();
        i = 0;
        while (i < 10000) {
            StackContext.enter();
            x = Float64.valueOf(1.0);
            j2 = 0;
            while (j2 < results.length) {
                results[j2] = ((Float64)x).times((Float64)x);
                ++j2;
            }
            StackContext.exit();
            ++i;
        }
        JScience.endTime(10000 * results.length);
        System.out.print("Complex add: ");
        JScience.startTime();
        i = 0;
        while (i < 10000) {
            StackContext.enter();
            x = Complex.valueOf(1.0, 2.0);
            j2 = 0;
            while (j2 < results.length) {
                results[j2] = ((Complex)x).plus((Complex)x);
                ++j2;
            }
            StackContext.exit();
            ++i;
        }
        JScience.endTime(10000 * results.length);
        System.out.print("Complex multiply: ");
        JScience.startTime();
        i = 0;
        while (i < 10000) {
            StackContext.enter();
            x = Complex.valueOf(1.0, 2.0);
            j2 = 0;
            while (j2 < results.length) {
                results[j2] = ((Complex)x).times((Complex)x);
                ++j2;
            }
            StackContext.exit();
            ++i;
        }
        JScience.endTime(10000 * results.length);
        System.out.print("Amount<Mass> add: ");
        JScience.startTime();
        i = 0;
        while (i < 10000) {
            StackContext.enter();
            x = Amount.valueOf(1.0, SI.KILOGRAM);
            j2 = 0;
            while (j2 < results.length) {
                results[j2] = ((Amount)x).plus((Amount)x);
                ++j2;
            }
            StackContext.exit();
            ++i;
        }
        JScience.endTime(10000 * results.length);
        System.out.print("Amount<Mass> multiply: ");
        JScience.startTime();
        i = 0;
        while (i < 10000) {
            StackContext.enter();
            x = Amount.valueOf(1.0, SI.KILOGRAM);
            j2 = 0;
            while (j2 < results.length) {
                results[j2] = ((Amount)x).times((Amount)x);
                ++j2;
            }
            StackContext.exit();
            ++i;
        }
        JScience.endTime(10000 * results.length);
        System.out.println();
        System.out.println("LargeInteger (StackContext) versus BigInteger");
        BigInteger big = BigInteger.probablePrime(1024, new Random());
        byte[] bytes = big.toByteArray();
        LargeInteger large = LargeInteger.valueOf(bytes, 0, bytes.length);
        System.out.print("LargeInteger (1024 bits) addition: ");
        JScience.startTime();
        int i2 = 0;
        while (i2 < 1000) {
            StackContext.enter();
            j = 0;
            while (j < results.length) {
                results[j] = large.plus(large);
                ++j;
            }
            StackContext.exit();
            ++i2;
        }
        JScience.endTime(1000 * results.length);
        System.out.print("LargeInteger (1024 bits) multiplication: ");
        JScience.startTime();
        i2 = 0;
        while (i2 < 100) {
            StackContext.enter();
            j = 0;
            while (j < results.length) {
                results[j] = large.times(large);
                ++j;
            }
            StackContext.exit();
            ++i2;
        }
        JScience.endTime(100 * results.length);
        System.out.print("BigInteger (1024 bits) addition: ");
        JScience.startTime();
        i2 = 0;
        while (i2 < 1000) {
            j = 0;
            while (j < results.length) {
                results[j] = big.add(big);
                ++j;
            }
            ++i2;
        }
        JScience.endTime(1000 * results.length);
        System.out.print("BigInteger (1024 bits) multiplication: ");
        JScience.startTime();
        i2 = 0;
        while (i2 < 100) {
            j = 0;
            while (j < results.length) {
                results[j] = big.multiply(big);
                ++j;
            }
            ++i2;
        }
        JScience.endTime(100 * results.length);
        System.out.println();
        System.out.println("Matrix<Float64> and Matrix<Complex> versus non-parameterized matrix (double)");
        double[][] values = new double[500][500];
        int i3 = 0;
        while (i3 < 500) {
            int j3 = 0;
            while (j3 < 500) {
                values[i3][j3] = MathLib.random();
                ++j3;
            }
            ++i3;
        }
        System.out.println("Javolution Concurrency Disabled");
        LocalContext.enter();
        try {
            ConcurrentContext.setConcurrency((int)0);
            JScience.multiplyMatrices(values);
        }
        finally {
            LocalContext.exit();
        }
        System.out.println("Javolution Concurrency: " + ConcurrentContext.getConcurrency());
        JScience.multiplyMatrices(values);
        System.out.println();
        System.out.println("More performance analysis in future versions...");
    }

    private static void multiplyMatrices(double[][] values) {
        int size = values.length;
        System.out.print("Non-parameterized matrix (double based) 500x500 multiplication: ");
        int i = 0;
        while (i < size) {
            int j = 0;
            while (j < size) {
                values[i][j] = MathLib.random();
                ++j;
            }
            ++i;
        }
        MatrixDouble PM = new MatrixDouble(values);
        int i2 = 0;
        while (i2 < 5) {
            PM.times(PM);
            ++i2;
        }
        JScience.startTime();
        MatrixDouble R1 = PM.times(PM);
        JScience.endTime(1);
        System.out.print("Matrix<Float64> 500x500 multiplication: ");
        Float64Matrix FM = Float64Matrix.valueOf(values);
        int i3 = 0;
        while (i3 < 5) {
            ((Matrix)FM).times(FM);
            ++i3;
        }
        JScience.startTime();
        Matrix<Float64> R2 = ((Matrix)FM).times(FM);
        JScience.endTime(1);
        if (!R2.equals(Float64Matrix.valueOf(R1.o))) {
            throw new Error("Error in matrix multiplication");
        }
        System.out.print("Matrix<Complex> 500x500 multiplication: ");
        Complex[][] complexes = new Complex[size][size];
        int i4 = 0;
        while (i4 < size) {
            int j = 0;
            while (j < size) {
                complexes[i4][j] = Complex.valueOf(MathLib.random(), MathLib.random());
                ++j;
            }
            ++i4;
        }
        ComplexMatrix CM = ComplexMatrix.valueOf(complexes);
        int i5 = 0;
        while (i5 < 5) {
            ((Matrix)CM).times(CM);
            ++i5;
        }
        JScience.startTime();
        ((Matrix)CM).times(CM);
        JScience.endTime(1);
        System.out.print("Matrix<Amount> 500x500 multiplication: ");
        Field[][] measures = new Amount[size][size];
        int i6 = 0;
        while (i6 < size) {
            int j = 0;
            while (j < size) {
                measures[i6][j] = Amount.valueOf(MathLib.random((long)Long.MIN_VALUE, (long)Long.MAX_VALUE), Unit.ONE);
                ++j;
            }
            ++i6;
        }
        DenseMatrix MM = DenseMatrix.valueOf((Field[][])measures);
        JScience.startTime();
        MM.times((Matrix)MM);
        JScience.endTime(1);
    }

    private static void startTime() {
        _time = System.nanoTime();
    }

    public static void endTime(int iterations) {
        long divisor;
        String unit;
        long nanoSeconds = System.nanoTime() - _time;
        long picoDuration = nanoSeconds * 1000L / (long)iterations;
        if (picoDuration > 1000000000000L) {
            unit = " s";
            divisor = 1000000000000L;
        } else if (picoDuration > 1000000000L) {
            unit = " ms";
            divisor = 1000000000L;
        } else if (picoDuration > 1000000L) {
            unit = " us";
            divisor = 1000000L;
        } else {
            unit = " ns";
            divisor = 1000L;
        }
        TextBuilder tb = TextBuilder.newInstance();
        tb.append(picoDuration / divisor);
        int fracDigits = 4 - tb.length();
        tb.append(".");
        int i = 0;
        int j = 10;
        while (i < fracDigits) {
            tb.append(picoDuration * (long)j / divisor % 10L);
            ++i;
            j *= 10;
        }
        System.out.println(tb.append(unit));
    }

    private static final class MatrixDouble {
        double[][] o;
        int m;
        int n;

        MatrixDouble(double[][] elements) {
            this.o = elements;
            this.m = elements.length;
            this.n = elements[0].length;
        }

        MatrixDouble times(MatrixDouble that) {
            if (that.m != this.n) {
                throw new Error("Wrong dimensions");
            }
            MatrixDouble M = new MatrixDouble(new double[this.m][that.n]);
            double[] thatColj = new double[this.n];
            int j = 0;
            while (j < that.n) {
                int k = 0;
                while (k < this.n) {
                    thatColj[k] = that.o[k][j];
                    ++k;
                }
                int i = 0;
                while (i < this.m) {
                    double[] thisRowi = this.o[i];
                    double s = 0.0;
                    int k2 = 0;
                    while (k2 < this.n) {
                        s += thisRowi[k2] * thatColj[k2];
                        ++k2;
                    }
                    M.o[i][j] = s;
                    ++i;
                }
                ++j;
            }
            return M;
        }
    }
}

