/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package QVTRelation.provider;

import QVTRelation.util.QVTRelationAdapterFactory;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class QVTRelationItemProviderAdapterFactory extends QVTRelationAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public QVTRelationItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link QVTRelation.DomainPattern} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DomainPatternItemProvider domainPatternItemProvider;

	/**
	 * This creates an adapter for a {@link QVTRelation.DomainPattern}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDomainPatternAdapter() {
		if (domainPatternItemProvider == null) {
			domainPatternItemProvider = new DomainPatternItemProvider(this);
		}

		return domainPatternItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link QVTRelation.Key} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected KeyItemProvider keyItemProvider;

	/**
	 * This creates an adapter for a {@link QVTRelation.Key}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createKeyAdapter() {
		if (keyItemProvider == null) {
			keyItemProvider = new KeyItemProvider(this);
		}

		return keyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link QVTRelation.OppositePropertyCallExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OppositePropertyCallExpItemProvider oppositePropertyCallExpItemProvider;

	/**
	 * This creates an adapter for a {@link QVTRelation.OppositePropertyCallExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOppositePropertyCallExpAdapter() {
		if (oppositePropertyCallExpItemProvider == null) {
			oppositePropertyCallExpItemProvider = new OppositePropertyCallExpItemProvider(this);
		}

		return oppositePropertyCallExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link QVTRelation.Relation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RelationItemProvider relationItemProvider;

	/**
	 * This creates an adapter for a {@link QVTRelation.Relation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRelationAdapter() {
		if (relationItemProvider == null) {
			relationItemProvider = new RelationItemProvider(this);
		}

		return relationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link QVTRelation.RelationCallExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RelationCallExpItemProvider relationCallExpItemProvider;

	/**
	 * This creates an adapter for a {@link QVTRelation.RelationCallExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRelationCallExpAdapter() {
		if (relationCallExpItemProvider == null) {
			relationCallExpItemProvider = new RelationCallExpItemProvider(this);
		}

		return relationCallExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link QVTRelation.RelationDomain} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RelationDomainItemProvider relationDomainItemProvider;

	/**
	 * This creates an adapter for a {@link QVTRelation.RelationDomain}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRelationDomainAdapter() {
		if (relationDomainItemProvider == null) {
			relationDomainItemProvider = new RelationDomainItemProvider(this);
		}

		return relationDomainItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link QVTRelation.RelationDomainAssignment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RelationDomainAssignmentItemProvider relationDomainAssignmentItemProvider;

	/**
	 * This creates an adapter for a {@link QVTRelation.RelationDomainAssignment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRelationDomainAssignmentAdapter() {
		if (relationDomainAssignmentItemProvider == null) {
			relationDomainAssignmentItemProvider = new RelationDomainAssignmentItemProvider(this);
		}

		return relationDomainAssignmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link QVTRelation.RelationImplementation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RelationImplementationItemProvider relationImplementationItemProvider;

	/**
	 * This creates an adapter for a {@link QVTRelation.RelationImplementation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRelationImplementationAdapter() {
		if (relationImplementationItemProvider == null) {
			relationImplementationItemProvider = new RelationImplementationItemProvider(this);
		}

		return relationImplementationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link QVTRelation.RelationalTransformation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RelationalTransformationItemProvider relationalTransformationItemProvider;

	/**
	 * This creates an adapter for a {@link QVTRelation.RelationalTransformation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRelationalTransformationAdapter() {
		if (relationalTransformationItemProvider == null) {
			relationalTransformationItemProvider = new RelationalTransformationItemProvider(this);
		}

		return relationalTransformationItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (domainPatternItemProvider != null) domainPatternItemProvider.dispose();
		if (keyItemProvider != null) keyItemProvider.dispose();
		if (oppositePropertyCallExpItemProvider != null) oppositePropertyCallExpItemProvider.dispose();
		if (relationItemProvider != null) relationItemProvider.dispose();
		if (relationCallExpItemProvider != null) relationCallExpItemProvider.dispose();
		if (relationDomainItemProvider != null) relationDomainItemProvider.dispose();
		if (relationDomainAssignmentItemProvider != null) relationDomainAssignmentItemProvider.dispose();
		if (relationImplementationItemProvider != null) relationImplementationItemProvider.dispose();
		if (relationalTransformationItemProvider != null) relationalTransformationItemProvider.dispose();
	}

}
