/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package EssentialOCL.provider;

import EssentialOCL.util.EssentialOCLAdapterFactory;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class EssentialOCLItemProviderAdapterFactory extends EssentialOCLAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EssentialOCLItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link EssentialOCL.AnyType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AnyTypeItemProvider anyTypeItemProvider;

	/**
	 * This creates an adapter for a {@link EssentialOCL.AnyType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAnyTypeAdapter() {
		if (anyTypeItemProvider == null) {
			anyTypeItemProvider = new AnyTypeItemProvider(this);
		}

		return anyTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link EssentialOCL.BagType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BagTypeItemProvider bagTypeItemProvider;

	/**
	 * This creates an adapter for a {@link EssentialOCL.BagType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBagTypeAdapter() {
		if (bagTypeItemProvider == null) {
			bagTypeItemProvider = new BagTypeItemProvider(this);
		}

		return bagTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link EssentialOCL.BooleanLiteralExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BooleanLiteralExpItemProvider booleanLiteralExpItemProvider;

	/**
	 * This creates an adapter for a {@link EssentialOCL.BooleanLiteralExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBooleanLiteralExpAdapter() {
		if (booleanLiteralExpItemProvider == null) {
			booleanLiteralExpItemProvider = new BooleanLiteralExpItemProvider(this);
		}

		return booleanLiteralExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link EssentialOCL.CollectionItem} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CollectionItemItemProvider collectionItemItemProvider;

	/**
	 * This creates an adapter for a {@link EssentialOCL.CollectionItem}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCollectionItemAdapter() {
		if (collectionItemItemProvider == null) {
			collectionItemItemProvider = new CollectionItemItemProvider(this);
		}

		return collectionItemItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link EssentialOCL.CollectionLiteralExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CollectionLiteralExpItemProvider collectionLiteralExpItemProvider;

	/**
	 * This creates an adapter for a {@link EssentialOCL.CollectionLiteralExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCollectionLiteralExpAdapter() {
		if (collectionLiteralExpItemProvider == null) {
			collectionLiteralExpItemProvider = new CollectionLiteralExpItemProvider(this);
		}

		return collectionLiteralExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link EssentialOCL.CollectionRange} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CollectionRangeItemProvider collectionRangeItemProvider;

	/**
	 * This creates an adapter for a {@link EssentialOCL.CollectionRange}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCollectionRangeAdapter() {
		if (collectionRangeItemProvider == null) {
			collectionRangeItemProvider = new CollectionRangeItemProvider(this);
		}

		return collectionRangeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link EssentialOCL.CollectionType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CollectionTypeItemProvider collectionTypeItemProvider;

	/**
	 * This creates an adapter for a {@link EssentialOCL.CollectionType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCollectionTypeAdapter() {
		if (collectionTypeItemProvider == null) {
			collectionTypeItemProvider = new CollectionTypeItemProvider(this);
		}

		return collectionTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link EssentialOCL.EnumLiteralExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EnumLiteralExpItemProvider enumLiteralExpItemProvider;

	/**
	 * This creates an adapter for a {@link EssentialOCL.EnumLiteralExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEnumLiteralExpAdapter() {
		if (enumLiteralExpItemProvider == null) {
			enumLiteralExpItemProvider = new EnumLiteralExpItemProvider(this);
		}

		return enumLiteralExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link EssentialOCL.ExpressionInOcl} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExpressionInOclItemProvider expressionInOclItemProvider;

	/**
	 * This creates an adapter for a {@link EssentialOCL.ExpressionInOcl}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExpressionInOclAdapter() {
		if (expressionInOclItemProvider == null) {
			expressionInOclItemProvider = new ExpressionInOclItemProvider(this);
		}

		return expressionInOclItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link EssentialOCL.IfExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IfExpItemProvider ifExpItemProvider;

	/**
	 * This creates an adapter for a {@link EssentialOCL.IfExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIfExpAdapter() {
		if (ifExpItemProvider == null) {
			ifExpItemProvider = new IfExpItemProvider(this);
		}

		return ifExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link EssentialOCL.IntegerLiteralExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IntegerLiteralExpItemProvider integerLiteralExpItemProvider;

	/**
	 * This creates an adapter for a {@link EssentialOCL.IntegerLiteralExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIntegerLiteralExpAdapter() {
		if (integerLiteralExpItemProvider == null) {
			integerLiteralExpItemProvider = new IntegerLiteralExpItemProvider(this);
		}

		return integerLiteralExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link EssentialOCL.InvalidLiteralExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InvalidLiteralExpItemProvider invalidLiteralExpItemProvider;

	/**
	 * This creates an adapter for a {@link EssentialOCL.InvalidLiteralExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInvalidLiteralExpAdapter() {
		if (invalidLiteralExpItemProvider == null) {
			invalidLiteralExpItemProvider = new InvalidLiteralExpItemProvider(this);
		}

		return invalidLiteralExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link EssentialOCL.InvalidType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InvalidTypeItemProvider invalidTypeItemProvider;

	/**
	 * This creates an adapter for a {@link EssentialOCL.InvalidType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInvalidTypeAdapter() {
		if (invalidTypeItemProvider == null) {
			invalidTypeItemProvider = new InvalidTypeItemProvider(this);
		}

		return invalidTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link EssentialOCL.IterateExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IterateExpItemProvider iterateExpItemProvider;

	/**
	 * This creates an adapter for a {@link EssentialOCL.IterateExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIterateExpAdapter() {
		if (iterateExpItemProvider == null) {
			iterateExpItemProvider = new IterateExpItemProvider(this);
		}

		return iterateExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link EssentialOCL.IteratorExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IteratorExpItemProvider iteratorExpItemProvider;

	/**
	 * This creates an adapter for a {@link EssentialOCL.IteratorExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIteratorExpAdapter() {
		if (iteratorExpItemProvider == null) {
			iteratorExpItemProvider = new IteratorExpItemProvider(this);
		}

		return iteratorExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link EssentialOCL.LetExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LetExpItemProvider letExpItemProvider;

	/**
	 * This creates an adapter for a {@link EssentialOCL.LetExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLetExpAdapter() {
		if (letExpItemProvider == null) {
			letExpItemProvider = new LetExpItemProvider(this);
		}

		return letExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link EssentialOCL.NavigationCallExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NavigationCallExpItemProvider navigationCallExpItemProvider;

	/**
	 * This creates an adapter for a {@link EssentialOCL.NavigationCallExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNavigationCallExpAdapter() {
		if (navigationCallExpItemProvider == null) {
			navigationCallExpItemProvider = new NavigationCallExpItemProvider(this);
		}

		return navigationCallExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link EssentialOCL.NullLiteralExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NullLiteralExpItemProvider nullLiteralExpItemProvider;

	/**
	 * This creates an adapter for a {@link EssentialOCL.NullLiteralExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNullLiteralExpAdapter() {
		if (nullLiteralExpItemProvider == null) {
			nullLiteralExpItemProvider = new NullLiteralExpItemProvider(this);
		}

		return nullLiteralExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link EssentialOCL.OperationCallExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OperationCallExpItemProvider operationCallExpItemProvider;

	/**
	 * This creates an adapter for a {@link EssentialOCL.OperationCallExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOperationCallExpAdapter() {
		if (operationCallExpItemProvider == null) {
			operationCallExpItemProvider = new OperationCallExpItemProvider(this);
		}

		return operationCallExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link EssentialOCL.OrderedSetType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OrderedSetTypeItemProvider orderedSetTypeItemProvider;

	/**
	 * This creates an adapter for a {@link EssentialOCL.OrderedSetType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOrderedSetTypeAdapter() {
		if (orderedSetTypeItemProvider == null) {
			orderedSetTypeItemProvider = new OrderedSetTypeItemProvider(this);
		}

		return orderedSetTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link EssentialOCL.PropertyCallExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PropertyCallExpItemProvider propertyCallExpItemProvider;

	/**
	 * This creates an adapter for a {@link EssentialOCL.PropertyCallExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPropertyCallExpAdapter() {
		if (propertyCallExpItemProvider == null) {
			propertyCallExpItemProvider = new PropertyCallExpItemProvider(this);
		}

		return propertyCallExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link EssentialOCL.RealLiteralExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RealLiteralExpItemProvider realLiteralExpItemProvider;

	/**
	 * This creates an adapter for a {@link EssentialOCL.RealLiteralExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRealLiteralExpAdapter() {
		if (realLiteralExpItemProvider == null) {
			realLiteralExpItemProvider = new RealLiteralExpItemProvider(this);
		}

		return realLiteralExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link EssentialOCL.SequenceType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SequenceTypeItemProvider sequenceTypeItemProvider;

	/**
	 * This creates an adapter for a {@link EssentialOCL.SequenceType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSequenceTypeAdapter() {
		if (sequenceTypeItemProvider == null) {
			sequenceTypeItemProvider = new SequenceTypeItemProvider(this);
		}

		return sequenceTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link EssentialOCL.SetType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SetTypeItemProvider setTypeItemProvider;

	/**
	 * This creates an adapter for a {@link EssentialOCL.SetType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSetTypeAdapter() {
		if (setTypeItemProvider == null) {
			setTypeItemProvider = new SetTypeItemProvider(this);
		}

		return setTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link EssentialOCL.StringLiteralExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StringLiteralExpItemProvider stringLiteralExpItemProvider;

	/**
	 * This creates an adapter for a {@link EssentialOCL.StringLiteralExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStringLiteralExpAdapter() {
		if (stringLiteralExpItemProvider == null) {
			stringLiteralExpItemProvider = new StringLiteralExpItemProvider(this);
		}

		return stringLiteralExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link EssentialOCL.TupleLiteralExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TupleLiteralExpItemProvider tupleLiteralExpItemProvider;

	/**
	 * This creates an adapter for a {@link EssentialOCL.TupleLiteralExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTupleLiteralExpAdapter() {
		if (tupleLiteralExpItemProvider == null) {
			tupleLiteralExpItemProvider = new TupleLiteralExpItemProvider(this);
		}

		return tupleLiteralExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link EssentialOCL.TupleLiteralPart} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TupleLiteralPartItemProvider tupleLiteralPartItemProvider;

	/**
	 * This creates an adapter for a {@link EssentialOCL.TupleLiteralPart}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTupleLiteralPartAdapter() {
		if (tupleLiteralPartItemProvider == null) {
			tupleLiteralPartItemProvider = new TupleLiteralPartItemProvider(this);
		}

		return tupleLiteralPartItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link EssentialOCL.TupleType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TupleTypeItemProvider tupleTypeItemProvider;

	/**
	 * This creates an adapter for a {@link EssentialOCL.TupleType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTupleTypeAdapter() {
		if (tupleTypeItemProvider == null) {
			tupleTypeItemProvider = new TupleTypeItemProvider(this);
		}

		return tupleTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link EssentialOCL.TypeExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TypeExpItemProvider typeExpItemProvider;

	/**
	 * This creates an adapter for a {@link EssentialOCL.TypeExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTypeExpAdapter() {
		if (typeExpItemProvider == null) {
			typeExpItemProvider = new TypeExpItemProvider(this);
		}

		return typeExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link EssentialOCL.TypeType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TypeTypeItemProvider typeTypeItemProvider;

	/**
	 * This creates an adapter for a {@link EssentialOCL.TypeType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTypeTypeAdapter() {
		if (typeTypeItemProvider == null) {
			typeTypeItemProvider = new TypeTypeItemProvider(this);
		}

		return typeTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link EssentialOCL.UnlimitedNaturalExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UnlimitedNaturalExpItemProvider unlimitedNaturalExpItemProvider;

	/**
	 * This creates an adapter for a {@link EssentialOCL.UnlimitedNaturalExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUnlimitedNaturalExpAdapter() {
		if (unlimitedNaturalExpItemProvider == null) {
			unlimitedNaturalExpItemProvider = new UnlimitedNaturalExpItemProvider(this);
		}

		return unlimitedNaturalExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link EssentialOCL.Variable} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VariableItemProvider variableItemProvider;

	/**
	 * This creates an adapter for a {@link EssentialOCL.Variable}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVariableAdapter() {
		if (variableItemProvider == null) {
			variableItemProvider = new VariableItemProvider(this);
		}

		return variableItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link EssentialOCL.VariableExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VariableExpItemProvider variableExpItemProvider;

	/**
	 * This creates an adapter for a {@link EssentialOCL.VariableExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVariableExpAdapter() {
		if (variableExpItemProvider == null) {
			variableExpItemProvider = new VariableExpItemProvider(this);
		}

		return variableExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link EssentialOCL.VoidType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VoidTypeItemProvider voidTypeItemProvider;

	/**
	 * This creates an adapter for a {@link EssentialOCL.VoidType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVoidTypeAdapter() {
		if (voidTypeItemProvider == null) {
			voidTypeItemProvider = new VoidTypeItemProvider(this);
		}

		return voidTypeItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (anyTypeItemProvider != null) anyTypeItemProvider.dispose();
		if (bagTypeItemProvider != null) bagTypeItemProvider.dispose();
		if (booleanLiteralExpItemProvider != null) booleanLiteralExpItemProvider.dispose();
		if (collectionItemItemProvider != null) collectionItemItemProvider.dispose();
		if (collectionLiteralExpItemProvider != null) collectionLiteralExpItemProvider.dispose();
		if (collectionRangeItemProvider != null) collectionRangeItemProvider.dispose();
		if (collectionTypeItemProvider != null) collectionTypeItemProvider.dispose();
		if (enumLiteralExpItemProvider != null) enumLiteralExpItemProvider.dispose();
		if (expressionInOclItemProvider != null) expressionInOclItemProvider.dispose();
		if (ifExpItemProvider != null) ifExpItemProvider.dispose();
		if (integerLiteralExpItemProvider != null) integerLiteralExpItemProvider.dispose();
		if (invalidLiteralExpItemProvider != null) invalidLiteralExpItemProvider.dispose();
		if (invalidTypeItemProvider != null) invalidTypeItemProvider.dispose();
		if (iterateExpItemProvider != null) iterateExpItemProvider.dispose();
		if (iteratorExpItemProvider != null) iteratorExpItemProvider.dispose();
		if (letExpItemProvider != null) letExpItemProvider.dispose();
		if (navigationCallExpItemProvider != null) navigationCallExpItemProvider.dispose();
		if (nullLiteralExpItemProvider != null) nullLiteralExpItemProvider.dispose();
		if (operationCallExpItemProvider != null) operationCallExpItemProvider.dispose();
		if (orderedSetTypeItemProvider != null) orderedSetTypeItemProvider.dispose();
		if (propertyCallExpItemProvider != null) propertyCallExpItemProvider.dispose();
		if (realLiteralExpItemProvider != null) realLiteralExpItemProvider.dispose();
		if (sequenceTypeItemProvider != null) sequenceTypeItemProvider.dispose();
		if (setTypeItemProvider != null) setTypeItemProvider.dispose();
		if (stringLiteralExpItemProvider != null) stringLiteralExpItemProvider.dispose();
		if (tupleLiteralExpItemProvider != null) tupleLiteralExpItemProvider.dispose();
		if (tupleLiteralPartItemProvider != null) tupleLiteralPartItemProvider.dispose();
		if (tupleTypeItemProvider != null) tupleTypeItemProvider.dispose();
		if (typeExpItemProvider != null) typeExpItemProvider.dispose();
		if (typeTypeItemProvider != null) typeTypeItemProvider.dispose();
		if (unlimitedNaturalExpItemProvider != null) unlimitedNaturalExpItemProvider.dispose();
		if (variableItemProvider != null) variableItemProvider.dispose();
		if (variableExpItemProvider != null) variableExpItemProvider.dispose();
		if (voidTypeItemProvider != null) voidTypeItemProvider.dispose();
	}

}
