/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.ui;

import de.uka.ipd.sdq.dialogs.error.ErrorDisplayDialog;
import de.uka.ipd.sdq.workflow.WorkflowPlugin;
import de.uka.ipd.sdq.workflow.exceptions.WorkflowExceptionHandler;
import org.eclipse.ui.PlatformUI;

public class UIBasedWorkflowExceptionHandler
extends WorkflowExceptionHandler {
    public UIBasedWorkflowExceptionHandler(boolean shouldThrowException) {
        super(shouldThrowException);
    }

    @Override
    protected void handleCriticalException(Exception e) {
        super.handleCriticalException(e);
        PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new ErrorDisplayRunner(e));
    }

    @Override
    protected void logException(Exception e) {
        WorkflowPlugin.log(4, e.getMessage());
    }

    private class ErrorDisplayRunner
    implements Runnable {
        private Throwable e;

        public ErrorDisplayRunner(Throwable e) {
            this.e = e;
        }

        @Override
        public void run() {
            new ErrorDisplayDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.e).open();
        }
    }
}

