/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.exceptions;

import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import de.uka.ipd.sdq.workflow.exceptions.WorkflowFailedException;

public class WorkflowExceptionHandler {
    protected boolean myShouldThrowException;

    public WorkflowExceptionHandler(boolean shouldThrowException) {
        this.myShouldThrowException = shouldThrowException;
    }

    protected void logException(Exception e) {
    }

    protected void handleCriticalException(Exception e) {
        this.logException(e);
        if (this.myShouldThrowException) {
            throw new WorkflowFailedException("Workflow failed", e);
        }
    }

    public void handleJobFailed(JobFailedException e) {
        this.handleCriticalException(e);
    }

    public void handleRollbackFailed(RollbackFailedException e) {
        this.handleCriticalException(e);
    }

    public void handleUserCanceled(UserCanceledException e) {
    }

    public void handleFatalFailure(Exception e) {
        this.handleCriticalException(e);
        throw new RuntimeException("Fatal failure occured at runtime", e);
    }
}

