/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow;

import de.uka.ipd.sdq.workflow.ICompositeJob;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.OrderPreservingCompositeJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import de.uka.ipd.sdq.workflow.exceptions.WorkflowExceptionHandler;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class Workflow
extends OrderPreservingCompositeJob
implements ICompositeJob {
    private IProgressMonitor myMonitor;
    protected Logger logger = null;
    protected WorkflowExceptionHandler exceptionHandler = null;

    public Workflow(IJob job) {
        this(job, null, new WorkflowExceptionHandler(false));
    }

    public Workflow(IJob job, WorkflowExceptionHandler exceptionHandler) {
        this(job, null, exceptionHandler);
    }

    public Workflow(IJob job, IProgressMonitor monitor, WorkflowExceptionHandler workflowExceptionHandler) {
        this.addJob(job);
        this.exceptionHandler = workflowExceptionHandler;
        this.myMonitor = monitor != null ? monitor : new NullProgressMonitor();
        this.logger = Logger.getLogger(Workflow.class);
    }

    /*
     * Loose catch block
     */
    public void run() {
        block19: {
            this.logger.info((Object)"Creating workflow engine and starting workflow");
            this.myMonitor.beginTask("Workflow", 1);
            this.myMonitor.subTask(this.getName());
            try {
                this.execute(this.myMonitor);
            }
            catch (JobFailedException e) {
                this.logger.error((Object)"Workflow job failed, handling failure...");
                this.logger.error((Object)"Failure reason was: ", (Throwable)e);
                this.exceptionHandler.handleJobFailed(e);
                this.logger.info((Object)"Cleaning up...");
                try {
                    this.rollback(this.myMonitor);
                }
                catch (RollbackFailedException e2) {
                    this.logger.error((Object)"Critical failure during workflow rollback");
                    this.exceptionHandler.handleRollbackFailed(e2);
                }
                break block19;
            }
            catch (UserCanceledException e) {
                this.logger.info((Object)"User canceled workflow");
                this.exceptionHandler.handleUserCanceled(e);
                break block19;
            }
            catch (Exception e) {
                this.logger.fatal((Object)"Workflow terminated unexpectedly", (Throwable)e);
                this.exceptionHandler.handleFatalFailure(e);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.logger.info((Object)"Cleaning up...");
                try {
                    this.rollback(this.myMonitor);
                }
                catch (RollbackFailedException e3) {
                    this.logger.error((Object)"Critical failure during workflow rollback");
                    this.exceptionHandler.handleRollbackFailed(e3);
                }
                break block19;
            }
            {
                finally {
                    this.logger.info((Object)"Cleaning up...");
                    try {
                        this.rollback(this.myMonitor);
                    }
                    catch (RollbackFailedException e) {
                        this.logger.error((Object)"Critical failure during workflow rollback");
                        this.exceptionHandler.handleRollbackFailed(e);
                    }
                }
            }
            this.logger.info((Object)"Cleaning up...");
            try {
                this.rollback(this.myMonitor);
            }
            catch (RollbackFailedException e) {
                this.logger.error((Object)"Critical failure during workflow rollback");
                this.exceptionHandler.handleRollbackFailed(e);
            }
        }
        this.myMonitor.worked(1);
        this.myMonitor.done();
        this.logger.info((Object)"Workflow engine completed task");
    }
}

